/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;

public abstract class AbstractTicketDelegator<T extends Ticket>
implements Ticket {
    private static final long serialVersionUID = 1780193477774123440L;
    private final AbstractDistributedTicketRegistry ticketRegistry;
    private final T ticket;
    private final boolean callback;

    protected AbstractTicketDelegator(AbstractDistributedTicketRegistry ticketRegistry, T ticket, boolean callback) {
        this.ticketRegistry = ticketRegistry;
        this.ticket = ticket;
        this.callback = callback;
    }

    protected void updateTicket() {
        this.ticketRegistry.updateTicket((Ticket)this.ticket);
    }

    protected T getTicket() {
        return this.ticket;
    }

    public final String getId() {
        return this.ticket.getId();
    }

    public final boolean isExpired() {
        if (!this.callback) {
            return this.ticket.isExpired();
        }
        TicketGrantingTicket t = this.getGrantingTicket();
        return this.ticket.isExpired() || t != null && t.isExpired();
    }

    public final TicketGrantingTicket getGrantingTicket() {
        TicketGrantingTicket old = this.ticket.getGrantingTicket();
        if (old == null || !this.callback) {
            return old;
        }
        return (TicketGrantingTicket)this.ticketRegistry.getTicket(old.getId(), Ticket.class);
    }

    public final long getCreationTime() {
        return this.ticket.getCreationTime();
    }

    public final int getCountOfUses() {
        return this.ticket.getCountOfUses();
    }

    public int hashCode() {
        return this.ticket.hashCode();
    }

    public boolean equals(Object o) {
        return this.ticket.equals(o);
    }

    public int compareTo(Ticket o) {
        return this.ticket.compareTo((Object)o);
    }
}

