/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Map;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractTicketRegistry
implements TicketRegistry,
TicketRegistryState {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public final <T extends Ticket> T getTicket(String ticketId, Class<? extends Ticket> clazz) {
        Assert.notNull(clazz, (String)"clazz cannot be null");
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(ticket.getClass())) {
            throw new ClassCastException("Ticket [" + ticket.getId() + " is of type " + ticket.getClass() + " when we were expecting " + clazz);
        }
        return (T)ticket;
    }

    public int sessionCount() {
        this.logger.debug("sessionCount() operation is not implemented by the ticket registry instance {}. Returning unknown as {}", (Object)this.getClass().getName(), (Object)Integer.MIN_VALUE);
        return Integer.MIN_VALUE;
    }

    public int serviceTicketCount() {
        this.logger.debug("serviceTicketCount() operation is not implemented by the ticket registry instance {}. Returning unknown as {}", (Object)this.getClass().getName(), (Object)Integer.MIN_VALUE);
        return Integer.MIN_VALUE;
    }

    public int deleteTicket(String ticketId) {
        int count = 0;
        if (ticketId == null) {
            return count;
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return count;
        }
        if (ticket instanceof TicketGrantingTicket) {
            if (ticket instanceof ProxyGrantingTicket) {
                this.logger.debug("Removing proxy-granting ticket [{}]", (Object)ticketId);
            }
            this.logger.debug("Removing children of ticket [{}] from the registry.", (Object)ticket.getId());
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            count += this.deleteChildren(tgt);
            Collection proxyGrantingTickets = tgt.getProxyGrantingTickets();
            for (ProxyGrantingTicket pgt : proxyGrantingTickets) {
                count += this.deleteTicket(pgt.getId());
            }
        }
        this.logger.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        if (this.deleteSingleTicket(ticketId)) {
            ++count;
        }
        return count;
    }

    public int deleteChildren(TicketGrantingTicket ticket) {
        int count = 0;
        Map services = ticket.getServices();
        if (services != null && !services.isEmpty()) {
            for (String ticketId : services.keySet()) {
                if (this.deleteSingleTicket(ticketId)) {
                    this.logger.debug("Removed ticket [{}]", (Object)ticketId);
                    ++count;
                    continue;
                }
                this.logger.debug("Unable to remove ticket [{}]", (Object)ticketId);
            }
        }
        return count;
    }

    public boolean deleteSingleTicket(Ticket ticketId) {
        return this.deleteSingleTicket(ticketId.getId());
    }

    public abstract boolean deleteSingleTicket(String var1);
}

