/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="defaultTicketRegistry")
public final class DefaultTicketRegistry
extends AbstractTicketRegistry {
    private final Map<String, Ticket> cache;

    public DefaultTicketRegistry() {
        this.cache = new ConcurrentHashMap<String, Ticket>();
    }

    @Autowired
    public DefaultTicketRegistry(@Value(value="${default.ticket.registry.initialcapacity:1000}") int initialCapacity, @Value(value="${default.ticket.registry.loadfactor:1}") float loadFactor, @Value(value="${default.ticket.registry.concurrency:20}") int concurrencyLevel) {
        this.cache = new ConcurrentHashMap<String, Ticket>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        this.logger.debug("Added ticket [{}] to registry.", (Object)ticket.getId());
        this.cache.put(ticket.getId(), ticket);
    }

    public Ticket getTicket(String ticketId) {
        if (ticketId == null) {
            return null;
        }
        this.logger.debug("Attempting to retrieve ticket [{}]", (Object)ticketId);
        Ticket ticket = this.cache.get(ticketId);
        if (ticket != null) {
            this.logger.debug("Ticket [{}] found in registry.", (Object)ticketId);
        }
        return ticket;
    }

    @Override
    public boolean deleteSingleTicket(String ticketId) {
        return this.cache.remove(ticketId) != null;
    }

    public Collection<Ticket> getTickets() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    @Override
    public int sessionCount() {
        int count = 0;
        for (Ticket t : this.cache.values()) {
            if (!(t instanceof TicketGrantingTicket)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int serviceTicketCount() {
        int count = 0;
        for (Ticket t : this.cache.values()) {
            if (!(t instanceof ServiceTicket)) continue;
            ++count;
        }
        return count;
    }
}

