/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistrySupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="defaultTicketRegistrySupport")
public class DefaultTicketRegistrySupport
implements TicketRegistrySupport {
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry = new DefaultTicketRegistry();

    public Authentication getAuthenticationFrom(String ticketGrantingTicketId) throws RuntimeException {
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        return tgt == null ? null : tgt.getAuthentication();
    }

    public Principal getAuthenticatedPrincipalFrom(String ticketGrantingTicketId) throws RuntimeException {
        Authentication auth = this.getAuthenticationFrom(ticketGrantingTicketId);
        return auth == null ? null : auth.getPrincipal();
    }

    public Map<String, Object> getPrincipalAttributesFrom(String ticketGrantingTicketId) throws RuntimeException {
        Principal principal = this.getAuthenticatedPrincipalFrom(ticketGrantingTicketId);
        return principal == null ? null : principal.getAttributes();
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

