/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jasig.cas.ticket.registry.AbstractTicketDelegator;
import org.springframework.transaction.annotation.Transactional;

public class TicketGrantingTicketDelegator<T extends TicketGrantingTicket>
extends AbstractTicketDelegator<T>
implements TicketGrantingTicket {
    private static final long serialVersionUID = 5312560061970601497L;

    TicketGrantingTicketDelegator(AbstractDistributedTicketRegistry ticketRegistry, T ticketGrantingTicket, boolean callback) {
        super(ticketRegistry, ticketGrantingTicket, callback);
    }

    public Authentication getAuthentication() {
        return ((TicketGrantingTicket)this.getTicket()).getAuthentication();
    }

    public Service getProxiedBy() {
        return ((TicketGrantingTicket)this.getTicket()).getProxiedBy();
    }

    public List<Authentication> getSupplementalAuthentications() {
        return ((TicketGrantingTicket)this.getTicket()).getSupplementalAuthentications();
    }

    @Transactional(readOnly=false, transactionManager="ticketTransactionManager")
    public ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided, boolean onlyTrackMostRecentSession) {
        ServiceTicket t = ((TicketGrantingTicket)this.getTicket()).grantServiceTicket(id, service, expirationPolicy, credentialsProvided, onlyTrackMostRecentSession);
        this.updateTicket();
        return t;
    }

    @Transactional(readOnly=false, transactionManager="ticketTransactionManager")
    public void markTicketExpired() {
        ((TicketGrantingTicket)this.getTicket()).markTicketExpired();
        this.updateTicket();
    }

    public boolean isRoot() {
        return ((TicketGrantingTicket)this.getTicket()).isRoot();
    }

    public TicketGrantingTicket getRoot() {
        return ((TicketGrantingTicket)this.getTicket()).getRoot();
    }

    public List<Authentication> getChainedAuthentications() {
        return ((TicketGrantingTicket)this.getTicket()).getChainedAuthentications();
    }

    public Map<String, Service> getServices() {
        return ((TicketGrantingTicket)this.getTicket()).getServices();
    }

    public void removeAllServices() {
        ((TicketGrantingTicket)this.getTicket()).removeAllServices();
    }

    public Collection<ProxyGrantingTicket> getProxyGrantingTickets() {
        return ((TicketGrantingTicket)this.getTicket()).getProxyGrantingTickets();
    }
}

