/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.support.WebUtils;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component(value="ticketRegistryCleaner")
public class TicketRegistryCleaner
implements Job {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="logoutManager")
    private LogoutManager logoutManager;
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler scheduler;
    @Value(value="${ticket.registry.cleaner.repeatinterval:120}")
    private int refreshInterval;
    @Value(value="${ticket.registry.cleaner.startdelay:20}")
    private int startDelay;
    @Autowired
    @NotNull
    private ApplicationContext applicationContext;

    @PostConstruct
    public void scheduleCleanerJob() {
        try {
            if (this.shouldScheduleCleanerJob()) {
                this.logger.info("Preparing to schedule job to clean up after tickets...");
                JobDetail job = JobBuilder.newJob(this.getClass()).withIdentity(this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).startAt(DateTime.now().plusSeconds(this.startDelay).toDate()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(this.refreshInterval).repeatForever()).build();
                this.logger.debug("Scheduling {} job", (Object)this.getClass().getSimpleName());
                this.scheduler.getContext().put(this.getClass().getSimpleName(), this.applicationContext.getBean("ticketRegistry", TicketRegistry.class));
                this.scheduler.scheduleJob(job, trigger);
                this.logger.info("{} will clean tickets every {} minutes", (Object)this.getClass().getSimpleName(), (Object)TimeUnit.SECONDS.toMinutes(this.refreshInterval));
            } else {
                this.logger.info("Ticket registry cleaner job will not be scheduled to run.");
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
        try {
            this.logger.info("Beginning ticket cleanup...");
            final TicketRegistry registry = (TicketRegistry)jobExecutionContext.getScheduler().getContext().get((Object)this.getClass().getSimpleName());
            this.logger.debug("Cleaning up tickets from an instance of {}", (Object)registry);
            Collection deletedTicketCounts = Collections2.transform((Collection)registry.getTickets(), (Function)new Function<Ticket, Integer>(){

                public Integer apply(@Nullable Ticket ticket) {
                    int count = 0;
                    if (ticket != null && ticket.isExpired()) {
                        if (ticket instanceof TicketGrantingTicket) {
                            TicketRegistryCleaner.this.logger.debug("Cleaning up expired ticket-granting ticket [{}]", (Object)ticket.getId());
                            TicketRegistryCleaner.this.logoutManager.performLogout((TicketGrantingTicket)ticket);
                            count += registry.deleteTicket(ticket.getId());
                        } else if (ticket instanceof ServiceTicket) {
                            TicketRegistryCleaner.this.logger.debug("Cleaning up expired service ticket [{}]", (Object)ticket.getId());
                            count += registry.deleteTicket(ticket.getId());
                        } else {
                            TicketRegistryCleaner.this.logger.warn("Unknown ticket type [{} found to clean", (Object)ticket.getClass().getSimpleName());
                        }
                    }
                    return count;
                }
            });
            int cumulativeCount = 0;
            Iterator iterator = deletedTicketCounts.iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                cumulativeCount += count;
            }
            this.logger.info("{} expired tickets found and removed.", (Object)cumulativeCount);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldScheduleCleanerJob() {
        if (this.startDelay > 0 && this.applicationContext.getParent() == null && this.scheduler != null) {
            if (WebUtils.isCasServletInitializing((ApplicationContext)this.applicationContext)) {
                return true;
            }
            this.logger.debug("Could not find CAS servlet application context");
        }
        return false;
    }
}

