/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.encrypt;

import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.CipherExecutor;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jasig.cas.ticket.registry.encrypt.EncodedTicket;
import org.jasig.cas.util.CompressionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractCrypticTicketRegistry
extends AbstractDistributedTicketRegistry {
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="ticketCipherExecutor")
    private CipherExecutor<byte[], byte[]> cipherExecutor;

    public void setCipherExecutor(CipherExecutor<byte[], byte[]> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    protected String encodeTicketId(String ticketId) {
        if (this.cipherExecutor == null) {
            this.logger.trace("Ticket encryption is not enabled. Falling back to default behavior");
            return ticketId;
        }
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return ticketId;
        }
        return CompressionUtils.sha512Hex((String)ticketId);
    }

    protected Ticket encodeTicket(Ticket ticket) {
        if (this.cipherExecutor == null) {
            this.logger.trace("Ticket encryption is not enabled. Falling back to default behavior");
            return ticket;
        }
        if (ticket == null) {
            return ticket;
        }
        this.logger.info("Encoding [{}]", (Object)ticket);
        byte[] encodedTicketObject = CompressionUtils.serializeAndEncodeObject(this.cipherExecutor, (Serializable)ticket);
        String encodedTicketId = this.encodeTicketId(ticket.getId());
        EncodedTicket encodedTicket = new EncodedTicket(ByteSource.wrap((byte[])encodedTicketObject), encodedTicketId);
        this.logger.info("Created [{}]", (Object)encodedTicket);
        return encodedTicket;
    }

    protected Ticket decodeTicket(Ticket result) {
        if (this.cipherExecutor == null) {
            this.logger.trace("Ticket encryption is not enabled. Falling back to default behavior");
            return result;
        }
        if (result == null) {
            return result;
        }
        this.logger.info("Attempting to decode {}", (Object)result);
        EncodedTicket encodedTicket = (EncodedTicket)result;
        Ticket ticket = (Ticket)CompressionUtils.decodeAndSerializeObject((byte[])encodedTicket.getEncoded(), this.cipherExecutor, Ticket.class);
        this.logger.info("Decoded {}", (Object)ticket);
        return ticket;
    }

    protected Collection<Ticket> decodeTickets(Collection<Ticket> items) {
        if (this.cipherExecutor == null) {
            this.logger.trace("Ticket encryption is not enabled. Falling back to default behavior");
            return items;
        }
        if (items == null || items.isEmpty()) {
            return items;
        }
        HashSet<Ticket> tickets = new HashSet<Ticket>(items.size());
        for (Ticket item : items) {
            Ticket ticket = this.decodeTicket(item);
            tickets.add(ticket);
        }
        return tickets;
    }
}

