/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="hardTimeoutExpirationPolicy")
public final class HardTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = 6728077010285422290L;
    @Value(value="#{${tgt.timeout.hard.maxTimeToLiveInSeconds:28800}*1000L}")
    private long timeToKillInMilliSeconds;

    private HardTimeoutExpirationPolicy() {
    }

    public HardTimeoutExpirationPolicy(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public HardTimeoutExpirationPolicy(long timeToKill, TimeUnit timeUnit) {
        this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
    }

    @PostConstruct
    public void init() {
        this.timeToKillInMilliSeconds = TimeUnit.SECONDS.toMillis(this.timeToKillInMilliSeconds);
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || System.currentTimeMillis() - ticketState.getCreationTime() >= this.timeToKillInMilliSeconds;
    }
}

