/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="multiTimeUseOrTimeoutExpirationPolicy")
public final class MultiTimeUseOrTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -5704993954986738308L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTimeUseOrTimeoutExpirationPolicy.class);
    @Value(value="#{${st.timeToKillInSeconds:10}*1000L}")
    private final long timeToKillInMilliSeconds;
    @Value(value="${st.numberOfUses:1}")
    private final int numberOfUses;

    private MultiTimeUseOrTimeoutExpirationPolicy() {
        this.timeToKillInMilliSeconds = 0L;
        this.numberOfUses = 0;
    }

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
        this.numberOfUses = numberOfUses;
        Assert.isTrue((this.numberOfUses > 0 ? 1 : 0) != 0, (String)"numberOfUses must be greater than 0.");
        Assert.isTrue((this.timeToKillInMilliSeconds > 0L ? 1 : 0) != 0, (String)"timeToKillInMilliseconds must be greater than 0.");
    }

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKill, TimeUnit timeUnit) {
        this(numberOfUses, timeUnit.toMillis(timeToKill));
    }

    public boolean isExpired(TicketState ticketState) {
        long lastTimeUsed;
        if (ticketState == null) {
            LOGGER.debug("Ticket state is null for {}", (Object)this.getClass().getSimpleName());
            return true;
        }
        long countUses = ticketState.getCountOfUses();
        if (countUses >= (long)this.numberOfUses) {
            LOGGER.debug("Ticket usage count {} is greater than or equal to {}", (Object)countUses, (Object)this.numberOfUses);
            return true;
        }
        long systemTime = System.currentTimeMillis();
        long difference = systemTime - (lastTimeUsed = ticketState.getLastTimeUsed());
        if (difference >= this.timeToKillInMilliSeconds) {
            LOGGER.debug("Ticket has expired because the difference between current time [{}] and ticket time [{}] is greater than or equal to [{}]", new Object[]{systemTime, lastTimeUsed, this.timeToKillInMilliSeconds});
            return true;
        }
        return false;
    }
}

