/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="rememberMeDelegatingExpirationPolicy")
public final class RememberMeDelegatingExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -2735975347698196127L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RememberMeDelegatingExpirationPolicy.class);
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="rememberMeExpirationPolicy")
    private ExpirationPolicy rememberMeExpirationPolicy;
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="sessionExpirationPolicy")
    private ExpirationPolicy sessionExpirationPolicy;

    @PostConstruct
    private void postConstruct() {
        if (this.rememberMeExpirationPolicy != null) {
            LOGGER.debug("Using remember-me expiration policy of {}", (Object)this.rememberMeExpirationPolicy);
        }
        if (this.sessionExpirationPolicy != null) {
            LOGGER.debug("Using session expiration policy of {}", (Object)this.sessionExpirationPolicy);
        }
    }

    public boolean isExpired(TicketState ticketState) {
        if (this.rememberMeExpirationPolicy != null && this.sessionExpirationPolicy != null) {
            Boolean b = (Boolean)ticketState.getAuthentication().getAttributes().get("org.jasig.cas.authentication.principal.REMEMBER_ME");
            if (b == null || b.equals(Boolean.FALSE)) {
                LOGGER.debug("Ticket is not associated with a remember-me authentication. Invoking {}", (Object)this.sessionExpirationPolicy);
                return this.sessionExpirationPolicy.isExpired(ticketState);
            }
            LOGGER.debug("Ticket is associated with a remember-me authentication. Invoking {}", (Object)this.rememberMeExpirationPolicy);
            return this.rememberMeExpirationPolicy.isExpired(ticketState);
        }
        LOGGER.warn("No expiration policy settings are defined");
        return false;
    }

    public void setRememberMeExpirationPolicy(ExpirationPolicy rememberMeExpirationPolicy) {
        this.rememberMeExpirationPolicy = rememberMeExpirationPolicy;
    }

    public void setSessionExpirationPolicy(ExpirationPolicy sessionExpirationPolicy) {
        this.sessionExpirationPolicy = sessionExpirationPolicy;
    }
}

