/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="ticketGrantingTicketExpirationPolicy")
public final class TicketGrantingTicketExpirationPolicy
extends AbstractCasExpirationPolicy
implements InitializingBean {
    private static final long serialVersionUID = 7670537200691354820L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketExpirationPolicy.class);
    @Value(value="#{${tgt.maxTimeToLiveInSeconds:28800}*1000L}")
    private long maxTimeToLiveInMilliSeconds;
    @Value(value="#{${tgt.timeToKillInSeconds:7200}*1000L}")
    private long timeToKillInMilliSeconds;

    private TicketGrantingTicketExpirationPolicy() {
    }

    public TicketGrantingTicketExpirationPolicy(long maxTimeToLive, long timeToKill, TimeUnit timeUnit) {
        this.maxTimeToLiveInMilliSeconds = timeUnit.toMillis(maxTimeToLive);
        this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
    }

    public void afterPropertiesSet() {
        Assert.isTrue((this.maxTimeToLiveInMilliSeconds >= this.timeToKillInMilliSeconds ? 1 : 0) != 0, (String)"maxTimeToLiveInMilliSeconds must be greater than or equal to timeToKillInMilliSeconds.");
    }

    public boolean isExpired(TicketState ticketState) {
        long currentSystemTimeInMillis = System.currentTimeMillis();
        if (currentSystemTimeInMillis - ticketState.getCreationTime() >= this.maxTimeToLiveInMilliSeconds) {
            LOGGER.debug("Ticket is expired because the time since creation is greater than maxTimeToLiveInMilliSeconds");
            return true;
        }
        if (currentSystemTimeInMillis - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds) {
            LOGGER.debug("Ticket is expired because the time since last use is greater than timeToKillInMilliseconds");
            return true;
        }
        return false;
    }
}

