/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

public class HostNameBasedUniqueTicketIdGenerator
extends DefaultUniqueTicketIdGenerator {
    public HostNameBasedUniqueTicketIdGenerator(int maxLength, String suffix) {
        super(maxLength, HostNameBasedUniqueTicketIdGenerator.determineTicketSuffixByHostName(suffix));
    }

    private static String determineTicketSuffixByHostName(String suffix) {
        try {
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                return suffix;
            }
            String hostName = InetAddress.getLocalHost().getCanonicalHostName();
            int index = hostName.indexOf(46);
            if (index > 0) {
                return hostName.substring(0, index);
            }
            return hostName;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Host name could not be determined automatically for the ticket suffix.", e);
        }
    }

    @Component(value="loginTicketUniqueIdGenerator")
    public static class LoginTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        @Autowired
        public LoginTicketIdGenerator(@Value(value="${lt.ticket.maxlength:20}") int maxLength, @Value(value="${host.name:cas01.example.org}") String suffix) {
            super(maxLength, suffix);
        }
    }

    @Component(value="proxy20TicketUniqueIdGenerator")
    public static class ProxyTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        @Autowired
        public ProxyTicketIdGenerator(@Value(value="${pgt.ticket.maxlength:50}") int maxLength, @Value(value="${host.name:cas01.example.org}") String suffix) {
            super(maxLength, suffix);
        }
    }

    @Component(value="serviceTicketUniqueIdGenerator")
    public static class ServiceTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        @Autowired
        public ServiceTicketIdGenerator(@Value(value="${st.ticket.maxlength:20}") int maxLength, @Value(value="${host.name:cas01.example.org}") String suffix) {
            super(maxLength, suffix);
        }
    }

    @Component(value="ticketGrantingTicketUniqueIdGenerator")
    public static class TicketGrantingTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        @Autowired
        public TicketGrantingTicketIdGenerator(@Value(value="${tgt.ticket.maxlength:50}") int maxLength, @Value(value="${host.name:cas01.example.org}") String suffix) {
            super(maxLength, suffix);
        }
    }
}

