/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.Key;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CipherExecutor;
import org.jasig.cas.util.CompressionUtils;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.keys.AesKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCipherExecutor<T, R>
implements CipherExecutor<T, R> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AesKey signingKey;

    protected AbstractCipherExecutor() {
    }

    public AbstractCipherExecutor(String signingSecretKey) {
        this.setSigningKey(signingSecretKey);
    }

    public void setSigningKey(String signingSecretKey) {
        this.signingKey = new AesKey(signingSecretKey.getBytes());
    }

    protected byte[] sign(byte[] value) {
        try {
            String base64 = CompressionUtils.encodeBase64(value);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(base64);
            jws.setAlgorithmHeaderValue("HS512");
            jws.setKey((Key)this.signingKey);
            return jws.getCompactSerialization().getBytes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[] verifySignature(@NotNull byte[] value) {
        try {
            String asString = new String(value);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(asString);
            jws.setKey((Key)this.signingKey);
            boolean verified = jws.verifySignature();
            if (verified) {
                String payload = jws.getPayload();
                this.logger.debug("Successfully decoded value. Result in Base64-encoding is [{}]", (Object)payload);
                return CompressionUtils.decodeBase64(payload);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

