/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import javax.validation.constraints.NotNull;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class CasSpringBeanJobFactory
extends SpringBeanJobFactory {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final ApplicationContext applicationContext;

    public CasSpringBeanJobFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        Object job = super.createJobInstance(bundle);
        this.logger.debug("Created job {} for bundle {}", job, (Object)bundle);
        beanFactory.autowireBean(job);
        this.logger.debug("Autowired job per the application context");
        return job;
    }
}

