/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.Key;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jasig.cas.util.DefaultCipherExecutor$AjcClosure1;
import org.jasig.cas.util.DefaultCipherExecutor$AjcClosure3;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultCookieCipherExecutor")
public final class DefaultCipherExecutor
extends AbstractCipherExecutor<String, String> {
    private String contentEncryptionAlgorithmIdentifier;
    private Key secretKeyEncryptionKey;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public DefaultCipherExecutor(@Value(value="${tgc.encryption.key:}") String secretKeyEncryption, @Value(value="${tgc.signing.key:}") String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256");
    }

    public DefaultCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier) {
        if (StringUtils.isBlank((CharSequence)secretKeyEncryption)) {
            this.logger.debug("secretKeyEncryption is not defined");
            return;
        }
        if (StringUtils.isBlank((CharSequence)secretKeySigning)) {
            this.logger.debug("secretKeySigning is not defined");
            return;
        }
        if (StringUtils.isBlank((CharSequence)contentEncryptionAlgorithmIdentifier)) {
            this.logger.debug("contentEncryptionAlgorithmIdentifier is not defined");
            return;
        }
        this.setSigningKey(secretKeySigning);
        this.secretKeyEncryptionKey = this.prepareJsonWebTokenKey(secretKeyEncryption);
        this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
        this.logger.debug("Initialized cipher encryption sequence via [{}]", (Object)contentEncryptionAlgorithmIdentifier);
    }

    public String encode(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new DefaultCipherExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String decode(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new DefaultCipherExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Key prepareJsonWebTokenKey(String secret) {
        try {
            HashMap<String, String> keys = new HashMap<String, String>(2);
            keys.put("kty", "oct");
            keys.put("k", secret);
            JsonWebKey jwk = JsonWebKey.Factory.newJwk(keys);
            return jwk.getKey();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(value);
            jwe.setAlgorithmHeaderValue("dir");
            jwe.setEncryptionMethodHeaderParameter(this.contentEncryptionAlgorithmIdentifier);
            jwe.setKey(this.secretKeyEncryptionKey);
            this.logger.debug("Encrypting via [{}]", (Object)this.contentEncryptionAlgorithmIdentifier);
            return jwe.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException("Ensure that you have installed JCE Unlimited Strength Jurisdiction Policy Files. " + e.getMessage(), e);
        }
    }

    private String decryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setKey(this.secretKeyEncryptionKey);
            jwe.setCompactSerialization(value);
            this.logger.debug("Decrypting value...");
            return jwe.getPayload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DefaultCipherExecutor.ajc$preClinit();
    }

    static final /* synthetic */ String encode_aroundBody0(DefaultCipherExecutor ajc$this, String value, JoinPoint joinPoint) {
        String encoded = ajc$this.encryptValue(value.toString());
        String signed = new String(ajc$this.sign(encoded.getBytes()));
        return signed;
    }

    static final /* synthetic */ String decode_aroundBody2(DefaultCipherExecutor ajc$this, String value, JoinPoint joinPoint) {
        byte[] encoded = ajc$this.verifySignature(value.getBytes());
        if (encoded != null && encoded.length > 0) {
            return ajc$this.decryptValue(new String(encoded));
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultCipherExecutor.java", DefaultCipherExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.jasig.cas.util.DefaultCipherExecutor", "java.lang.String", "value", "", "java.lang.String"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "decode", "org.jasig.cas.util.DefaultCipherExecutor", "java.lang.String", "value", "", "java.lang.String"), 92);
    }
}

