/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import javax.crypto.spec.SecretKeySpec;
import org.apache.shiro.crypto.AesCipherService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jasig.cas.util.ShiroCipherExecutor$AjcClosure1;
import org.jasig.cas.util.ShiroCipherExecutor$AjcClosure3;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="shiroCipherExecutor")
public class ShiroCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    private static final String UTF8_ENCODING = "UTF-8";
    private String secretKeyAlgorithm = "AES";
    private final String encryptionSecretKey;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public ShiroCipherExecutor(@Value(value="${ticket.encryption.secretkey:N0$ecr3T}") String encryptionSecretKey, @Value(value="${ticket.signing.secretkey:N0$ecr3T}") String signingSecretKey) {
        super(signingSecretKey);
        this.encryptionSecretKey = encryptionSecretKey;
    }

    @Autowired
    public void setSecretKeyAlgorithm(@Value(value="${ticket.secretkey.alg:AES}") String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public byte[] encode(byte[] value) {
        byte[] byArray = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)byArray);
        Object[] objectArray = new Object[]{this, byArray, joinPoint};
        return (byte[])TraceLogAspect.aspectOf().traceMethod(new ShiroCipherExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public byte[] decode(byte[] value) {
        byte[] byArray = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)byArray);
        Object[] objectArray = new Object[]{this, byArray, joinPoint};
        return (byte[])TraceLogAspect.aspectOf().traceMethod(new ShiroCipherExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        ShiroCipherExecutor.ajc$preClinit();
    }

    static final /* synthetic */ byte[] encode_aroundBody0(ShiroCipherExecutor ajc$this, byte[] value, JoinPoint joinPoint) {
        try {
            SecretKeySpec key = new SecretKeySpec(ajc$this.encryptionSecretKey.getBytes(), ajc$this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.encrypt(value, key.getEncoded()).getBytes();
            return ajc$this.sign(result);
        }
        catch (Exception e) {
            ajc$this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static final /* synthetic */ byte[] decode_aroundBody2(ShiroCipherExecutor ajc$this, byte[] value, JoinPoint joinPoint) {
        try {
            byte[] verifiedValue = ajc$this.verifySignature(value);
            SecretKeySpec key = new SecretKeySpec(ajc$this.encryptionSecretKey.getBytes(UTF8_ENCODING), ajc$this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.decrypt(verifiedValue, key.getEncoded()).getBytes();
            return result;
        }
        catch (Exception e) {
            ajc$this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShiroCipherExecutor.java", ShiroCipherExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.jasig.cas.util.ShiroCipherExecutor", "[B", "value", "", "[B"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "decode", "org.jasig.cas.util.ShiroCipherExecutor", "[B", "value", "", "[B"), 64);
    }
}

