/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.jasig.cas.util.JsonSerializer;

public abstract class AbstractJacksonBackedJsonSerializer<T>
implements JsonSerializer<T> {
    private static final long serialVersionUID = -8415599777321259365L;
    private final PrettyPrinter prettyPrinter;
    private final ObjectMapper objectMapper;

    public AbstractJacksonBackedJsonSerializer() {
        this((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public AbstractJacksonBackedJsonSerializer(PrettyPrinter prettyPrinter) {
        this.objectMapper = this.initializeObjectMapper();
        this.prettyPrinter = prettyPrinter;
    }

    public AbstractJacksonBackedJsonSerializer(ObjectMapper objectMapper, PrettyPrinter prettyPrinter) {
        this.objectMapper = objectMapper;
        this.prettyPrinter = prettyPrinter;
    }

    @Override
    public T fromJson(String json) {
        try {
            String jsonString = JsonValue.readHjson((String)json).toString();
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T fromJson(File json) {
        try {
            String jsonString = JsonValue.readHjson((String)FileUtils.readFileToString((File)json)).toString();
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T fromJson(Reader json) {
        try {
            String jsonString = JsonValue.readHjson((Reader)json).toString();
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T fromJson(InputStream json) {
        try {
            String jsonString = JsonValue.readHjson((String)IOUtils.toString((InputStream)json)).toString();
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void toJson(OutputStream out, T object) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter writer = new StringWriter();){
                this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
                String hjsonString = JsonValue.readHjson((String)writer.toString()).toString(Stringify.HJSON);
                IOUtils.write((String)hjsonString, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void toJson(Writer out, T object) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter writer = new StringWriter();){
                this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
                JsonValue.readHjson((String)writer.toString()).writeTo(out, Stringify.FORMATTED);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void toJson(File out, T object) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter writer = new StringWriter();){
                this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
                JsonValue.readHjson((String)writer.toString()).writeTo((Writer)new BufferedWriter(new FileWriter(out)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return mapper;
    }

    protected abstract Class<T> getTypeToSerialize();
}

