/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.jasig.cas.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);
    private static final int INFLATED_ARRAY_LENGTH = 10000;
    private static final String UTF8_ENCODING = "UTF-8";

    private CompressionUtils() {
    }

    public static String inflate(byte[] bytes) {
        Inflater inflater = new Inflater(true);
        byte[] xmlMessageBytes = new byte[10000];
        byte[] extendedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, extendedBytes, 0, bytes.length);
        extendedBytes[bytes.length] = 0;
        inflater.setInput(extendedBytes);
        try {
            int resultLength = inflater.inflate(xmlMessageBytes);
            inflater.end();
            if (!inflater.finished()) {
                throw new RuntimeException("buffer not large enough.");
            }
            inflater.end();
            return new String(xmlMessageBytes, 0, resultLength, UTF8_ENCODING);
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot find encoding: UTF-8", e);
        }
    }

    public static String deflate(byte[] bytes) {
        String data = new String(bytes, Charset.forName(UTF8_ENCODING));
        return CompressionUtils.deflate(data);
    }

    public static String deflate(String data) {
        try {
            Deflater deflater = new Deflater();
            deflater.setInput(data.getBytes(UTF8_ENCODING));
            deflater.finish();
            byte[] buffer = new byte[data.length()];
            int resultSize = deflater.deflate(buffer);
            byte[] output = new byte[resultSize];
            System.arraycopy(buffer, 0, output, 0, resultSize);
            return CompressionUtils.encodeBase64(output);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot find encoding:UTF-8", e);
        }
    }

    public static String encodeBase64(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decodeBase64((String)data);
    }

    public static byte[] encodeBase64ToByteArray(byte[] data) {
        return Base64.encodeBase64((byte[])data);
    }

    public static byte[] decodeBase64ToByteArray(String data) {
        try {
            byte[] bytes = data.getBytes(UTF8_ENCODING);
            return CompressionUtils.decodeBase64ToByteArray(bytes);
        }
        catch (Exception e) {
            LOGGER.error("Base64 decoding failed", (Throwable)e);
            return null;
        }
    }

    public static byte[] decodeBase64ToByteArray(byte[] data) {
        try {
            return Base64.decodeBase64((byte[])data);
        }
        catch (Exception e) {
            LOGGER.error("Base64 decoding failed", (Throwable)e);
            return null;
        }
    }

    public static String decodeByteArrayToString(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[bytes.length];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InflaterInputStream iis = new InflaterInputStream(bais);){
                int count = iis.read(buf);
                while (count != -1) {
                    baos.write(buf, 0, count);
                    count = iis.read(buf);
                }
                return new String(baos.toByteArray(), Charset.forName(UTF8_ENCODING));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Base64 decoding failed", (Throwable)e);
            return null;
        }
    }

    public static byte[] serializeAndEncodeObject(CipherExecutor<byte[], byte[]> cipher, Serializable object) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        SerializationUtils.serialize((Serializable)object, (OutputStream)outBytes);
        return (byte[])cipher.encode((Object)outBytes.toByteArray());
    }

    public static <T> T decodeAndSerializeObject(byte[] object, CipherExecutor<byte[], byte[]> cipher, Class<? extends Serializable> type) {
        byte[] decoded = (byte[])cipher.decode((Object)object);
        Object result = SerializationUtils.deserialize((byte[])decoded);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Decoded object is of type " + result.getClass() + " when we were expecting " + type);
        }
        return (T)result;
    }

    public static String sha512Hex(String input) {
        return DigestUtils.sha512Hex((String)input);
    }
}

