/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.SecureRandom;
import org.jasig.cas.util.RandomStringGenerator;

public final class DefaultRandomStringGenerator
implements RandomStringGenerator {
    protected static final int DEFAULT_MAX_RANDOM_LENGTH = 35;
    private static final char[] PRINTABLE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679".toCharArray();
    private final SecureRandom randomizer = new SecureRandom();
    private final int maximumRandomLength;

    public DefaultRandomStringGenerator() {
        this.maximumRandomLength = 35;
    }

    public DefaultRandomStringGenerator(int maxRandomLength) {
        this.maximumRandomLength = maxRandomLength;
    }

    @Override
    public int getMinLength() {
        return this.maximumRandomLength;
    }

    @Override
    public int getMaxLength() {
        return this.maximumRandomLength;
    }

    @Override
    public String getNewString() {
        byte[] random = this.getNewStringAsBytes();
        return DefaultRandomStringGenerator.convertBytesToString(random);
    }

    @Override
    public byte[] getNewStringAsBytes() {
        byte[] random = new byte[this.maximumRandomLength];
        this.randomizer.nextBytes(random);
        return random;
    }

    private static String convertBytesToString(byte[] random) {
        char[] output = new char[random.length];
        int i = 0;
        while (i < random.length) {
            int index = Math.abs(random[i] % PRINTABLE_CHARACTERS.length);
            output[i] = PRINTABLE_CHARACTERS[index];
            ++i;
        }
        return new String(output);
    }
}

