/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public final class PrivateKeyFactoryBean
extends AbstractFactoryBean<PrivateKey> {
    @NotNull
    private Resource location;
    @NotNull
    private String algorithm;

    protected PrivateKey createInstance() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream privKey = this.location.getInputStream();){
            byte[] bytes = new byte[privKey.available()];
            privKey.read(bytes);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            return factory.generatePrivate(privSpec);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Class getObjectType() {
        return PrivateKey.class;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Resource getLocation() {
        return this.location;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

