/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class PublicKeyFactoryBean
extends AbstractFactoryBean<PublicKey> {
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Resource resource;
    @NotNull
    private String algorithm;

    protected final PublicKey createInstance() throws Exception {
        this.logger.debug("Creating public key instance from [{}] using [{}]", (Object)this.resource.getFilename(), (Object)this.algorithm);
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream pubKey = this.resource.getInputStream();){
            byte[] bytes = new byte[pubKey.available()];
            pubKey.read(bytes);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            return factory.generatePublic(pubSpec);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Class getObjectType() {
        return PublicKey.class;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setLocation(Resource resource) {
        this.resource = resource;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("resource", (Object)this.resource).append("algorithm", (Object)this.algorithm).toString();
    }
}

