/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import javax.crypto.spec.SecretKeySpec;
import org.apache.shiro.crypto.AesCipherService;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="shiroCipherExecutor")
public class ShiroCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    private static final String UTF8_ENCODING = "UTF-8";
    private String secretKeyAlgorithm = "AES";
    private final String encryptionSecretKey;

    @Autowired
    public ShiroCipherExecutor(@Value(value="${ticket.encryption.secretkey:N0$ecr3T}") String encryptionSecretKey, @Value(value="${ticket.signing.secretkey:N0$ecr3T}") String signingSecretKey) {
        super(signingSecretKey);
        this.encryptionSecretKey = encryptionSecretKey;
    }

    @Autowired
    public void setSecretKeyAlgorithm(@Value(value="${ticket.secretkey.alg:AES}") String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public byte[] encode(byte[] value) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey.getBytes(), this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.encrypt(value, key.getEncoded()).getBytes();
            return this.sign(result);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] decode(byte[] value) {
        try {
            byte[] verifiedValue = this.verifySignature(value);
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey.getBytes(UTF8_ENCODING), this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.decrypt(verifiedValue, key.getEncoded()).getBytes();
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

