/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.Locale;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="messageInterpolator")
public final class SpringAwareMessageMessageInterpolator
implements MessageInterpolator,
MessageSourceAware {
    private final MessageInterpolator defaultMessageInterpolator = Validation.byDefaultProvider().configure().getDefaultMessageInterpolator();
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String interpolate(String s, MessageInterpolator.Context context) {
        return this.interpolate(s, context, LocaleContextHolder.getLocale());
    }

    public String interpolate(String s, MessageInterpolator.Context context, Locale locale) {
        try {
            return this.messageSource.getMessage(s, context.getConstraintDescriptor().getAttributes().values().toArray(new Object[context.getConstraintDescriptor().getAttributes().size()]), locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return this.defaultMessageInterpolator.interpolate(s, context, locale);
        }
    }
}

