/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.web.AbstractServletContextInitializer$AjcClosure1;
import org.jasig.cas.web.AbstractServletContextInitializer$AjcClosure3;
import org.jasig.cas.web.AbstractServletContextInitializer$AjcClosure5;
import org.jasig.cas.web.AbstractServletContextInitializer$AjcClosure7;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;

@Component
public abstract class AbstractServletContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
WebApplicationInitializer,
ServletContextListener,
ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ApplicationContext applicationContext;
    private final String contextInitializerName = this.getClass().getSimpleName();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected AbstractServletContextInitializer() {
    }

    public final void contextInitialized(ServletContextEvent sce) {
        ServletContextEvent servletContextEvent = sce;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)servletContextEvent);
        Object[] objectArray = new Object[]{this, servletContextEvent, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractServletContextInitializer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void contextDestroyed(ServletContextEvent sce) {
        ServletContextEvent servletContextEvent = sce;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)servletContextEvent);
        Object[] objectArray = new Object[]{this, servletContextEvent, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractServletContextInitializer$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableApplicationContext configurableApplicationContext2 = configurableApplicationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)configurableApplicationContext2);
        Object[] objectArray = new Object[]{this, configurableApplicationContext2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractServletContextInitializer$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void onStartup(ServletContext servletContext) throws ServletException {
        ServletContext servletContext2 = servletContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)servletContext2);
        Object[] objectArray = new Object[]{this, servletContext2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractServletContextInitializer$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected void onStartupServletContext(ServletContext servletContext) {
    }

    protected void initializeApplicationContext(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        try {
            this.logger.info("Initializing {} root application context", (Object)this.contextInitializerName);
            this.initializeRootApplicationContext();
            this.logger.info("Initialized {} root application context successfully", (Object)this.contextInitializerName);
            this.logger.info("Initializing {} servlet application context", (Object)this.contextInitializerName);
            this.initializeServletApplicationContext();
            this.logger.info("Initialized {} servlet application context successfully", (Object)this.contextInitializerName);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected final void addAuthenticationHandlerPrincipalResolver(AuthenticationHandler handler, PrincipalResolver resolver) {
        this.logger.debug("Adding {} and {} to application context", (Object)handler, (Object)resolver);
        Map authenticationHandlersResolvers = (Map)this.applicationContext.getBean("authenticationHandlersResolvers", Map.class);
        authenticationHandlersResolvers.put(handler, resolver);
    }

    protected final void addAuthenticationHandler(AuthenticationHandler handler) {
        this.addAuthenticationHandlerPrincipalResolver(handler, null);
    }

    protected final void addAuthenticationMetadataPopulator(AuthenticationMetaDataPopulator populator) {
        this.logger.debug("Adding {} to application context", (Object)populator);
        List authenticationMetadataPopulators = (List)this.applicationContext.getBean("authenticationMetadataPopulators", List.class);
        authenticationMetadataPopulators.add(populator);
    }

    protected final ConfigurableEnvironment getEnvironment() {
        return (ConfigurableEnvironment)this.applicationContext.getEnvironment();
    }

    protected final ServletRegistration getCasServletRegistration(ServletContextEvent sce) {
        ServletRegistration registration = sce.getServletContext().getServletRegistration("cas");
        if (registration == null) {
            this.logger.debug("Servlet [{}] is not registered with this context", (Object)"cas");
        }
        return registration;
    }

    protected final void addRegisteredServiceToServicesManager(RegisteredService svc) {
        this.logger.debug("Adding {} to application context services", (Object)svc);
        ReloadableServicesManager manager = this.getServicesManager();
        manager.save(svc);
    }

    protected final ReloadableServicesManager getServicesManager() {
        return (ReloadableServicesManager)this.applicationContext.getBean("servicesManager", ReloadableServicesManager.class);
    }

    protected final SimpleUrlHandlerMapping getCasServletHandlerMapping() {
        SimpleUrlHandlerMapping handlerMappingC = (SimpleUrlHandlerMapping)this.applicationContext.getBean("handlerMappingC", SimpleUrlHandlerMapping.class);
        return handlerMappingC;
    }

    protected final void addControllerToCasServletHandlerMapping(String path, Object controller) {
        this.logger.debug("Adding {} to application context for {}", controller, (Object)path);
        SimpleUrlHandlerMapping handlerMappingC = this.getCasServletHandlerMapping();
        Map urlMap = handlerMappingC.getUrlMap();
        urlMap.put(path, controller);
        handlerMappingC.initApplicationContext();
    }

    protected final void addControllerToCasServletHandlerMapping(String path, String controller) {
        this.addControllerToCasServletHandlerMapping(path, this.getController(controller));
    }

    protected final Controller getController(String id) {
        return (Controller)this.applicationContext.getBean(id, Controller.class);
    }

    protected final void addEndpointMappingToCasServlet(ServletContextEvent sce, String mapping) {
        this.logger.info("Adding [{}] to {} servlet context", (Object)mapping, (Object)"cas");
        ServletRegistration registration = this.getCasServletRegistration(sce);
        if (registration != null) {
            registration.addMapping(new String[]{mapping});
            this.logger.info("Added [{}] to {} servlet context", (Object)mapping, (Object)"cas");
        }
    }

    protected final void addArgumentExtractor(ArgumentExtractor ext) {
        this.logger.debug("Adding [{}] application context", (Object)ext);
        List list = (List)this.applicationContext.getBean("argumentExtractors", List.class);
        list.add(ext);
    }

    protected void addServiceFactory(ServiceFactory<? extends Service> factory) {
        this.logger.debug("Adding [{}] application context", factory);
        List list = (List)this.applicationContext.getBean("serviceFactoryList", List.class);
        list.add(factory);
    }

    protected final void addServiceTicketUniqueIdGenerator(String serviceName, UniqueTicketIdGenerator gen) {
        this.logger.debug("Adding [{}] for {} application context", (Object)serviceName, (Object)gen);
        Map map = (Map)this.applicationContext.getBean("uniqueIdGeneratorsMap", Map.class);
        map.put(serviceName, gen);
    }

    protected void initializeRootApplicationContext() {
    }

    protected void initializeServletApplicationContext() {
    }

    protected void initializeServletContext(ServletContextEvent event) {
    }

    protected void destroyServletContext(ServletContextEvent event) {
    }

    static {
        AbstractServletContextInitializer.ajc$preClinit();
    }

    static final /* synthetic */ void contextInitialized_aroundBody0(AbstractServletContextInitializer ajc$this, ServletContextEvent sce, JoinPoint joinPoint) {
        ajc$this.logger.info("Initializing {} context...", (Object)ajc$this.contextInitializerName);
        ajc$this.initializeServletContext(sce);
        ajc$this.logger.info("Initialized {} context...", (Object)ajc$this.contextInitializerName);
    }

    static final /* synthetic */ void contextDestroyed_aroundBody2(AbstractServletContextInitializer ajc$this, ServletContextEvent sce, JoinPoint joinPoint) {
        ajc$this.logger.info("Destroying {} context...", (Object)ajc$this.contextInitializerName);
        ajc$this.destroyServletContext(sce);
        ajc$this.logger.info("Destroyed {} context...", (Object)ajc$this.contextInitializerName);
    }

    static final /* synthetic */ void initialize_aroundBody4(AbstractServletContextInitializer ajc$this, ConfigurableApplicationContext configurableApplicationContext, JoinPoint joinPoint) {
        ajc$this.logger.info("Initializing application context...");
        ajc$this.initializeApplicationContext(configurableApplicationContext);
    }

    static final /* synthetic */ void onStartup_aroundBody6(AbstractServletContextInitializer ajc$this, ServletContext servletContext, JoinPoint joinPoint) {
        ajc$this.logger.info("Starting up servlet application context...");
        ajc$this.onStartupServletContext(servletContext);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractServletContextInitializer.java", AbstractServletContextInitializer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "contextInitialized", "org.jasig.cas.web.AbstractServletContextInitializer", "javax.servlet.ServletContextEvent", "sce", "", "void"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "contextDestroyed", "org.jasig.cas.web.AbstractServletContextInitializer", "javax.servlet.ServletContextEvent", "sce", "", "void"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "initialize", "org.jasig.cas.web.AbstractServletContextInitializer", "org.springframework.context.ConfigurableApplicationContext", "configurableApplicationContext", "", "void"), 76);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "onStartup", "org.jasig.cas.web.AbstractServletContextInitializer", "javax.servlet.ServletContext", "servletContext", "javax.servlet.ServletException", "void"), 82);
    }
}

