/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction$AjcClosure1;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction$AjcClosure3;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction$AjcClosure5;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component
public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAction {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    @Qualifier(value="principalFactory")
    protected PrincipalFactory principalFactory;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired(required=false)
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected final boolean isRenewPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getRequestParameters().get("renew"));
    }

    protected final Event doExecute(RequestContext context) {
        Credential credential = this.constructCredentialsFromRequest(context);
        if (credential == null) {
            return this.error();
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
        WebApplicationService service = WebUtils.getService(context);
        if (this.isRenewPresent(context) && ticketGrantingTicketId != null && service != null) {
            try {
                DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
                AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
                this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
                AuthenticationContext authenticationContext = builder.build((Service)service);
                ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, authenticationContext);
                WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                this.onWarn(context, credential);
                return this.result("warn");
            }
            catch (AuthenticationException authenticationException) {
                this.onError(context, credential);
                return this.error();
            }
            catch (AbstractTicketException e) {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                this.logger.debug("Attempted to generate a ServiceTicket using renew=true with different credential", (Throwable)e);
            }
        }
        try {
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
            this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
            AuthenticationContext authenticationContext = builder.build((Service)service);
            TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(authenticationContext);
            WebUtils.putTicketGrantingTicketInScopes(context, tgt);
            this.onSuccess(context, credential);
            return this.success();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            this.onError(context, credential);
            return this.error();
        }
    }

    public CentralAuthenticationService getCentralAuthenticationService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (CentralAuthenticationService)TraceLogAspect.aspectOf().traceMethod(new AbstractNonInteractiveCredentialsAction$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected void onError(RequestContext context, Credential credential) {
    }

    protected void onSuccess(RequestContext context, Credential credential) {
    }

    public PrincipalFactory getPrincipalFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (PrincipalFactory)TraceLogAspect.aspectOf().traceMethod(new AbstractNonInteractiveCredentialsAction$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AuthenticationSystemSupport)TraceLogAspect.aspectOf().traceMethod(new AbstractNonInteractiveCredentialsAction$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected void onWarn(RequestContext context, Credential credential) {
        WebUtils.putWarnCookieIfRequestParameterPresent(this.warnCookieGenerator, context);
    }

    protected abstract Credential constructCredentialsFromRequest(RequestContext var1);

    static {
        AbstractNonInteractiveCredentialsAction.ajc$preClinit();
    }

    static final /* synthetic */ CentralAuthenticationService getCentralAuthenticationService_aroundBody0(AbstractNonInteractiveCredentialsAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.centralAuthenticationService;
    }

    static final /* synthetic */ PrincipalFactory getPrincipalFactory_aroundBody2(AbstractNonInteractiveCredentialsAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.principalFactory;
    }

    static final /* synthetic */ AuthenticationSystemSupport getAuthenticationSystemSupport_aroundBody4(AbstractNonInteractiveCredentialsAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.authenticationSystemSupport;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractNonInteractiveCredentialsAction.java", AbstractNonInteractiveCredentialsAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCentralAuthenticationService", "org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction", "", "", "", "org.jasig.cas.CentralAuthenticationService"), 132);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrincipalFactory", "org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction", "", "", "", "org.jasig.cas.authentication.principal.PrincipalFactory"), 172);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthenticationSystemSupport", "org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction", "", "", "", "org.jasig.cas.authentication.AuthenticationSystemSupport"), 176);
    }
}

