/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;

@Component
public abstract class AbstractServletContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
WebApplicationInitializer,
ServletContextListener,
ApplicationContextAware {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ApplicationContext applicationContext;
    private final String contextInitializerName = this.getClass().getSimpleName();

    protected AbstractServletContextInitializer() {
    }

    public final void contextInitialized(ServletContextEvent sce) {
        this.logger.info("Initializing {} context...", (Object)this.contextInitializerName);
        this.initializeServletContext(sce);
        this.logger.info("Initialized {} context...", (Object)this.contextInitializerName);
    }

    public final void contextDestroyed(ServletContextEvent sce) {
        this.logger.info("Destroying {} context...", (Object)this.contextInitializerName);
        this.destroyServletContext(sce);
        this.logger.info("Destroyed {} context...", (Object)this.contextInitializerName);
    }

    public final void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        this.logger.info("Initializing application context...");
        this.initializeApplicationContext(configurableApplicationContext);
    }

    public final void onStartup(ServletContext servletContext) throws ServletException {
        this.logger.info("Starting up servlet application context...");
        this.onStartupServletContext(servletContext);
    }

    protected void onStartupServletContext(ServletContext servletContext) {
    }

    protected void initializeApplicationContext(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        try {
            if (applicationContext instanceof ConfigurableWebApplicationContext) {
                ConfigurableWebApplicationContext web = (ConfigurableWebApplicationContext)applicationContext;
                web.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, this.applicationContext.getBean("metrics"));
                web.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, this.applicationContext.getBean("healthCheckMetrics"));
            }
            this.logger.info("Initializing {} root application context", (Object)this.contextInitializerName);
            this.initializeRootApplicationContext();
            this.logger.info("Initialized {} root application context successfully", (Object)this.contextInitializerName);
            this.logger.info("Initializing {} servlet application context", (Object)this.contextInitializerName);
            this.initializeServletApplicationContext();
            this.logger.info("Initialized {} servlet application context successfully", (Object)this.contextInitializerName);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected final void addAuthenticationHandlerPrincipalResolver(AuthenticationHandler handler, PrincipalResolver resolver) {
        this.logger.debug("Adding {} and {} to application context", (Object)handler, (Object)resolver);
        Map authenticationHandlersResolvers = (Map)this.applicationContext.getBean("authenticationHandlersResolvers", Map.class);
        authenticationHandlersResolvers.put(handler, resolver);
    }

    protected final void addAuthenticationHandler(AuthenticationHandler handler) {
        this.addAuthenticationHandlerPrincipalResolver(handler, null);
    }

    protected final void addAuthenticationMetadataPopulator(AuthenticationMetaDataPopulator populator) {
        this.logger.debug("Adding {} to application context", (Object)populator);
        List authenticationMetadataPopulators = (List)this.applicationContext.getBean("authenticationMetadataPopulators", List.class);
        authenticationMetadataPopulators.add(populator);
    }

    protected final ConfigurableEnvironment getEnvironment() {
        return (ConfigurableEnvironment)this.applicationContext.getEnvironment();
    }

    protected final ServletRegistration getCasServletRegistration(ServletContextEvent sce) {
        ServletRegistration registration = sce.getServletContext().getServletRegistration("cas");
        if (registration == null) {
            this.logger.debug("Servlet [{}] is not registered with this context", (Object)"cas");
        }
        return registration;
    }

    protected final void addRegisteredServiceToServicesManager(RegisteredService svc) {
        this.logger.debug("Adding {} to application context services", (Object)svc);
        ReloadableServicesManager manager = this.getServicesManager();
        manager.save(svc);
    }

    protected final ReloadableServicesManager getServicesManager() {
        return (ReloadableServicesManager)this.applicationContext.getBean("servicesManager", ReloadableServicesManager.class);
    }

    protected final SimpleUrlHandlerMapping getCasServletHandlerMapping() {
        SimpleUrlHandlerMapping handlerMappingC = (SimpleUrlHandlerMapping)this.applicationContext.getBean("handlerMappingC", SimpleUrlHandlerMapping.class);
        return handlerMappingC;
    }

    protected final void addControllerToCasServletHandlerMapping(String path, Object controller) {
        try {
            this.logger.debug("Adding {} to application context for {}", controller, (Object)path);
            SimpleUrlHandlerMapping handlerMappingC = this.getCasServletHandlerMapping();
            Map urlMap = handlerMappingC.getUrlMap();
            urlMap.put(path, controller);
            handlerMappingC.initApplicationContext();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected final void addControllerToCasServletHandlerMapping(String path, String controller) {
        this.addControllerToCasServletHandlerMapping(path, this.getController(controller));
    }

    protected final Controller getController(String id) {
        return (Controller)this.applicationContext.getBean(id, Controller.class);
    }

    protected final void addEndpointMappingToCasServlet(ServletContextEvent sce, String mapping) {
        this.logger.info("Adding [{}] to {} servlet context", (Object)mapping, (Object)"cas");
        ServletRegistration registration = this.getCasServletRegistration(sce);
        if (registration != null) {
            registration.addMapping(new String[]{mapping});
            this.logger.info("Added [{}] to {} servlet context", (Object)mapping, (Object)"cas");
        }
    }

    protected final void addArgumentExtractor(ArgumentExtractor ext) {
        this.logger.debug("Adding [{}] application context", (Object)ext);
        List list = (List)this.applicationContext.getBean("argumentExtractors", List.class);
        list.add(ext);
    }

    protected void addServiceFactory(ServiceFactory<? extends Service> factory) {
        this.logger.debug("Adding [{}] application context", factory);
        List list = (List)this.applicationContext.getBean("serviceFactoryList", List.class);
        list.add(factory);
    }

    protected final void addServiceTicketUniqueIdGenerator(String serviceName, UniqueTicketIdGenerator gen) {
        this.logger.debug("Adding [{}] for {} application context", (Object)serviceName, (Object)gen);
        Map map = (Map)this.applicationContext.getBean("uniqueIdGeneratorsMap", Map.class);
        map.put(serviceName, gen);
    }

    protected void initializeRootApplicationContext() {
    }

    protected void initializeServletApplicationContext() {
    }

    protected void initializeServletContext(ServletContextEvent event) {
    }

    protected void destroyServletContext(ServletContextEvent event) {
    }
}

