/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.net.URI;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public final class WebUtils {
    public static final String CAS_SERVLET_NAME = "cas";
    public static final String CAS_ACCESS_DENIED_REASON = "CAS_ACCESS_DENIED_REASON";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebUtils.class);
    private static final String UNKNOWN_USER = "audit:unknown";

    private WebUtils() {
    }

    public static HttpServletRequest getHttpServletRequest(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletRequest)context.getExternalContext().getNativeRequest();
    }

    public static HttpServletRequest getHttpServletRequest() {
        ServletExternalContext servletExternalContext = (ServletExternalContext)ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletRequest)servletExternalContext.getNativeRequest();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponse(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletResponse)context.getExternalContext().getNativeResponse();
    }

    public static HttpServletResponse getHttpServletResponse() {
        ServletExternalContext servletExternalContext = (ServletExternalContext)ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletResponse)servletExternalContext.getNativeResponse();
        }
        return null;
    }

    public static boolean isCasServletInitializing(ServletContext sce) {
        return sce.getServletRegistrations().containsKey(CAS_SERVLET_NAME);
    }

    public static boolean isCasServletInitializing(ServletContextEvent sce) {
        return sce.getServletContext().getServletRegistrations().containsKey(CAS_SERVLET_NAME);
    }

    public static boolean isCasServletInitializing(WebApplicationContext sce) {
        return WebUtils.isCasServletInitializing(sce.getServletContext());
    }

    public static boolean isCasServletInitializing(ApplicationContext sce) {
        if (sce instanceof WebApplicationContext) {
            return WebUtils.isCasServletInitializing(((WebApplicationContext)sce).getServletContext());
        }
        LOGGER.debug("No CAS servlet is available because the given application context is not of type {}", WebApplicationContext.class);
        return false;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, HttpServletRequest request) {
        for (ArgumentExtractor argumentExtractor : argumentExtractors) {
            WebApplicationService service = argumentExtractor.extractService(request);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        return WebUtils.getService(argumentExtractors, request);
    }

    public static WebApplicationService getService(RequestContext context) {
        return context != null ? (WebApplicationService)context.getFlowScope().get("service") : null;
    }

    public static RegisteredService getRegisteredService(RequestContext context) {
        return context != null ? (RegisteredService)context.getFlowScope().get("registeredService") : null;
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, @NotNull TicketGrantingTicket ticket) {
        String ticketValue = ticket != null ? ticket.getId() : null;
        WebUtils.putTicketGrantingTicketInScopes(context, ticketValue);
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, @NotNull String ticketValue) {
        WebUtils.putTicketGrantingTicketIntoMap(context.getRequestScope(), ticketValue);
        WebUtils.putTicketGrantingTicketIntoMap(context.getFlowScope(), ticketValue);
    }

    public static void putTicketGrantingTicketIntoMap(MutableAttributeMap map, @NotNull String ticketValue) {
        map.put("ticketGrantingTicketId", (Object)ticketValue);
    }

    public static String getTicketGrantingTicketId(@NotNull RequestContext context) {
        String tgtFromRequest = (String)context.getRequestScope().get("ticketGrantingTicketId");
        String tgtFromFlow = (String)context.getFlowScope().get("ticketGrantingTicketId");
        return tgtFromRequest != null ? tgtFromRequest : tgtFromFlow;
    }

    public static void putServiceTicketInRequestScope(RequestContext context, ServiceTicket ticketValue) {
        context.getRequestScope().put("serviceTicketId", (Object)ticketValue.getId());
    }

    public static String getServiceTicketFromRequestScope(RequestContext context) {
        return context.getRequestScope().getString("serviceTicketId");
    }

    public static void putUnauthorizedRedirectUrlIntoFlowScope(RequestContext context, URI url) {
        context.getFlowScope().put("unauthorizedRedirectUrl", (Object)url);
    }

    public static void putLogoutRequests(RequestContext context, List<LogoutRequest> requests) {
        context.getFlowScope().put("logoutRequests", requests);
    }

    public static List<LogoutRequest> getLogoutRequests(RequestContext context) {
        return (List)context.getFlowScope().get("logoutRequests");
    }

    public static void putService(RequestContext context, Service service) {
        context.getFlowScope().put("service", (Object)service);
    }

    public static void putWarningCookie(RequestContext context, Boolean cookieValue) {
        context.getFlowScope().put("warnCookieValue", (Object)cookieValue);
    }

    public static void putRegisteredService(RequestContext context, RegisteredService registeredService) {
        context.getFlowScope().put("registeredService", (Object)registeredService);
    }

    public static Credential getCredential(@NotNull RequestContext context) {
        Credential credential;
        Credential cFromRequest = (Credential)context.getRequestScope().get("credential");
        Credential cFromFlow = (Credential)context.getFlowScope().get("credential");
        Credential credential2 = credential = cFromRequest != null ? cFromRequest : cFromFlow;
        if (credential != null && StringUtils.isBlank((CharSequence)credential.getId())) {
            return null;
        }
        return credential;
    }

    public static String getAuthenticatedUsername() {
        String id;
        J2EContext context;
        ProfileManager manager;
        UserProfile profile;
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        HttpServletResponse response = WebUtils.getHttpServletResponse();
        if (request != null && response != null && (profile = (manager = new ProfileManager((WebContext)(context = new J2EContext(request, response)))).get(true)) != null && (id = profile.getId()) != null) {
            return id;
        }
        return UNKNOWN_USER;
    }

    public static void putWarnCookieIfRequestParameterPresent(CookieGenerator warnCookieGenerator, RequestContext context) {
        if (warnCookieGenerator != null) {
            LOGGER.debug("Evaluating request to determine if warning cookie should be generated");
            HttpServletResponse response = WebUtils.getHttpServletResponse(context);
            if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get("warn"))) {
                warnCookieGenerator.addCookie(response, "true");
            } else {
                warnCookieGenerator.removeCookie(response);
            }
        } else {
            LOGGER.debug("No warning cookie generator is defined");
        }
    }

    public static void putUnauthorizedRedirectUrl(RequestContext context, URI unauthorizedRedirectUrl) {
        context.getFlowScope().put("unauthorizedRedirectUrl", (Object)unauthorizedRedirectUrl);
    }
}

