/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure1;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure11;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure3;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure5;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure7;
import org.jasig.cas.ticket.registry.JpaTicketRegistry$AjcClosure9;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.transaction.annotation.Transactional;

public final class JpaTicketRegistry
extends AbstractDistributedTicketRegistry {
    @NotNull
    @PersistenceContext
    private EntityManager entityManager;
    @NotNull
    private String ticketGrantingTicketPrefix = "TGT";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Transactional(readOnly=false)
    protected void updateTicket(Ticket ticket) {
        this.entityManager.merge((Object)ticket);
        this.logger.debug("Updated ticket [{}].", (Object)ticket);
    }

    @Transactional(readOnly=false)
    public void addTicket(Ticket ticket) {
        Ticket ticket2 = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)ticket2);
        Object[] objectArray = new Object[]{this, ticket2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Transactional(readOnly=false)
    public boolean deleteTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private void deleteTicketAndChildren(Ticket ticket) {
        List ticketGrantingTicketImpls = this.entityManager.createQuery("select t from TicketGrantingTicketImpl t where t.ticketGrantingTicket.id = :id", TicketGrantingTicketImpl.class).setLockMode(LockModeType.PESSIMISTIC_WRITE).setParameter("id", (Object)ticket.getId()).getResultList();
        List serviceTicketImpls = this.entityManager.createQuery("select s from ServiceTicketImpl s where s.ticketGrantingTicket.id = :id", ServiceTicketImpl.class).setParameter("id", (Object)ticket.getId()).getResultList();
        for (ServiceTicketImpl s : serviceTicketImpls) {
            this.removeTicket((Ticket)s);
        }
        for (TicketGrantingTicketImpl t : ticketGrantingTicketImpls) {
            this.deleteTicketAndChildren((Ticket)t);
        }
        this.removeTicket(ticket);
    }

    private void removeTicket(Ticket ticket) {
        try {
            if (this.logger.isDebugEnabled()) {
                Date creationDate = new Date(ticket.getCreationTime());
                this.logger.debug("Removing Ticket [{}] created: {}", (Object)ticket, (Object)creationDate.toString());
            }
            this.entityManager.remove((Object)ticket);
        }
        catch (Exception e) {
            this.logger.error("Error removing {} from registry.", (Object)ticket, (Object)e);
        }
    }

    @Transactional(readOnly=true)
    public Ticket getTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Ticket)TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith(this.ticketGrantingTicketPrefix)) {
                return (Ticket)this.entityManager.find(TicketGrantingTicketImpl.class, (Object)ticketId, LockModeType.PESSIMISTIC_WRITE);
            }
            return (Ticket)this.entityManager.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.logger.error("Error getting ticket {} from registry.", (Object)ticketId, (Object)e);
            return null;
        }
    }

    @Transactional(readOnly=true)
    public Collection<Ticket> getTickets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setTicketGrantingTicketPrefix(String ticketGrantingTicketPrefix) {
        this.ticketGrantingTicketPrefix = ticketGrantingTicketPrefix;
    }

    protected boolean needsCallback() {
        return false;
    }

    @Transactional(readOnly=true)
    public int sessionCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Transactional(readOnly=true)
    public int serviceTicketCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new JpaTicketRegistry$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private int countToInt(Object result) {
        int intval = result instanceof Long ? ((Long)result).intValue() : (result instanceof Integer ? ((Integer)result).intValue() : ((Number)result).intValue());
        return intval;
    }

    static {
        JpaTicketRegistry.ajc$preClinit();
    }

    static final /* synthetic */ void addTicket_aroundBody0(JpaTicketRegistry ajc$this, Ticket ticket, JoinPoint joinPoint) {
        ajc$this.entityManager.persist((Object)ticket);
        ajc$this.logger.debug("Added ticket [{}] to registry.", (Object)ticket);
    }

    static final /* synthetic */ boolean deleteTicket_aroundBody2(JpaTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        Ticket ticket = ajc$this.getRawTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof ServiceTicket) {
            ajc$this.removeTicket(ticket);
            ajc$this.logger.debug("Deleted ticket [{}] from the registry.", (Object)ticket);
            return true;
        }
        ajc$this.deleteTicketAndChildren(ticket);
        ajc$this.logger.debug("Deleted ticket [{}] and its children from the registry.", (Object)ticket);
        return true;
    }

    static final /* synthetic */ Ticket getTicket_aroundBody4(JpaTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        return ajc$this.getProxiedTicketInstance(ajc$this.getRawTicket(ticketId));
    }

    static final /* synthetic */ Collection getTickets_aroundBody6(JpaTicketRegistry ajc$this, JoinPoint joinPoint) {
        List tgts = ajc$this.entityManager.createQuery("select t from TicketGrantingTicketImpl t", TicketGrantingTicketImpl.class).getResultList();
        List sts = ajc$this.entityManager.createQuery("select s from ServiceTicketImpl s", ServiceTicketImpl.class).getResultList();
        ArrayList tickets = new ArrayList();
        tickets.addAll(tgts);
        tickets.addAll(sts);
        return tickets;
    }

    static final /* synthetic */ int sessionCount_aroundBody8(JpaTicketRegistry ajc$this, JoinPoint joinPoint) {
        return ajc$this.countToInt(ajc$this.entityManager.createQuery("select count(t) from TicketGrantingTicketImpl t").getSingleResult());
    }

    static final /* synthetic */ int serviceTicketCount_aroundBody10(JpaTicketRegistry ajc$this, JoinPoint joinPoint) {
        return ajc$this.countToInt(ajc$this.entityManager.createQuery("select count(t) from ServiceTicketImpl t").getSingleResult());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JpaTicketRegistry.java", JpaTicketRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "org.jasig.cas.ticket.Ticket", "ticket", "", "void"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String", "ticketId", "", "boolean"), 73);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String", "ticketId", "", "org.jasig.cas.ticket.Ticket"), 139);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "java.util.Collection"), 164);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sessionCount", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "int"), 190);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serviceTicketCount", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "int"), 197);
    }
}

