/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$AjcClosure1;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$AjcClosure3;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$AjcClosure5;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$AjcClosure7;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock$AjcClosure1;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock$AjcClosure3;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock$AjcClosure5;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class JpaLockingStrategy
implements LockingStrategy {
    public static final int DEFAULT_LOCK_TIMEOUT = 3600;
    @NotNull
    @PersistenceContext
    protected EntityManager entityManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private String applicationId;
    @NotNull
    private String uniqueId;
    private int lockTimeout = 3600;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }

    public void setLockTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Lock timeout must be non-negative.");
        }
        this.lockTimeout = seconds;
    }

    @Transactional(readOnly=false)
    public boolean acquire() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Transactional(readOnly=false)
    public void release() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Transactional(readOnly=true)
    public String getOwner() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean acquire(EntityManager em, Lock lock) {
        lock.setUniqueId(this.uniqueId);
        if (this.lockTimeout > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, this.lockTimeout);
            lock.setExpirationDate(cal.getTime());
        } else {
            lock.setExpirationDate(null);
        }
        boolean success = false;
        try {
            if (lock.getApplicationId() != null) {
                em.merge((Object)lock);
            } else {
                lock.setApplicationId(this.applicationId);
                em.persist((Object)lock);
            }
            success = true;
        }
        catch (PersistenceException e) {
            success = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} could not obtain {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            }
            this.logger.info("{} could not obtain {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
        }
        return success;
    }

    static {
        JpaLockingStrategy.ajc$preClinit();
    }

    static final /* synthetic */ boolean acquire_aroundBody0(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock;
        try {
            lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        }
        catch (PersistenceException e) {
            ajc$this.logger.debug("{} failed querying for {} lock.", new Object[]{ajc$this.uniqueId, ajc$this.applicationId, e});
            return false;
        }
        boolean result = false;
        if (lock != null) {
            DateTime expDate = new DateTime((Object)lock.getExpirationDate());
            if (lock.getUniqueId() == null) {
                ajc$this.logger.debug("{} trying to acquire {} lock.", (Object)ajc$this.uniqueId, (Object)ajc$this.applicationId);
                result = ajc$this.acquire(ajc$this.entityManager, lock);
            } else if (new DateTime().isAfter((ReadableInstant)expDate)) {
                ajc$this.logger.debug("{} trying to acquire expired {} lock.", (Object)ajc$this.uniqueId, (Object)ajc$this.applicationId);
                result = ajc$this.acquire(ajc$this.entityManager, lock);
            }
        } else {
            ajc$this.logger.debug("Creating {} lock initially held by {}.", (Object)ajc$this.applicationId, (Object)ajc$this.uniqueId);
            result = ajc$this.acquire(ajc$this.entityManager, new Lock());
        }
        return result;
    }

    static final /* synthetic */ void release_aroundBody2(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        if (lock == null) {
            return;
        }
        String owner = lock.getUniqueId();
        if (!ajc$this.uniqueId.equals(owner)) {
            throw new IllegalStateException("Cannot release lock owned by " + owner);
        }
        lock.setUniqueId(null);
        lock.setExpirationDate(null);
        ajc$this.logger.debug("Releasing {} lock held by {}.", (Object)ajc$this.applicationId, (Object)ajc$this.uniqueId);
        ajc$this.entityManager.persist((Object)lock);
    }

    static final /* synthetic */ String getOwner_aroundBody4(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        Lock lock = (Lock)ajc$this.entityManager.find(Lock.class, (Object)ajc$this.applicationId);
        if (lock != null) {
            return lock.getUniqueId();
        }
        return null;
    }

    static final /* synthetic */ String toString_aroundBody6(JpaLockingStrategy ajc$this, JoinPoint joinPoint) {
        return ajc$this.uniqueId;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JpaLockingStrategy.java", JpaLockingStrategy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "acquire", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "boolean"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "release", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "void"), 149);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwner", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "java.lang.String"), 174);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy", "", "", "", "java.lang.String"), 187);
    }

    @Entity
    @Table(name="locks")
    private static class Lock {
        @Id
        @Column(name="application_id")
        private String applicationId;
        @Column(name="unique_id")
        private String uniqueId;
        @Temporal(value=TemporalType.TIMESTAMP)
        @Column(name="expiration_date")
        private Date expirationDate;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private Lock() {
        }

        public String getApplicationId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$Lock$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getUniqueId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$Lock$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public DateTime getExpirationDate() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            return (DateTime)TraceLogAspect.aspectOf().traceMethod(new JpaLockingStrategy$Lock$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        static {
            Lock.ajc$preClinit();
        }

        static final /* synthetic */ String getApplicationId_aroundBody0(Lock ajc$this, JoinPoint joinPoint) {
            return ajc$this.applicationId;
        }

        static final /* synthetic */ String getUniqueId_aroundBody2(Lock ajc$this, JoinPoint joinPoint) {
            return ajc$this.uniqueId;
        }

        static final /* synthetic */ DateTime getExpirationDate_aroundBody4(Lock ajc$this, JoinPoint joinPoint) {
            return ajc$this.expirationDate == null ? null : new DateTime((Object)ajc$this.expirationDate);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JpaLockingStrategy.java", Lock.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApplicationId", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "java.lang.String"), 254);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUniqueId", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "java.lang.String"), 268);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpirationDate", "org.jasig.cas.ticket.registry.support.JpaLockingStrategy$Lock", "", "", "", "org.joda.time.DateTime"), 282);
        }
    }
}

