/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryAndEncodeDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_PASSWORD_FIELD = "password";
    private static final String DEFAULT_SALT_FIELD = "salt";
    private static final String DEFAULT_NUM_ITERATIONS_FIELD = "numIterations";
    @NotNull
    protected final String algorithmName;
    @NotNull
    protected final String sql;
    @NotNull
    protected String passwordFieldName = "password";
    @NotNull
    protected String saltFieldName = "salt";
    @NotNull
    protected String numberOfIterationsFieldName = "numIterations";
    protected long numberOfIterations;
    protected String staticSalt;

    public QueryAndEncodeDatabaseAuthenticationHandler(DataSource datasource, String sql, String algorithmName) {
        this.setDataSource(datasource);
        this.sql = sql;
        this.algorithmName = algorithmName;
    }

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential) throws GeneralSecurityException, PreventedException {
        String username = this.getPrincipalNameTransformer().transform(transformedCredential.getUsername());
        String encodedPsw = this.getPasswordEncoder().encode(transformedCredential.getPassword());
        try {
            Map values = this.getJdbcTemplate().queryForMap(this.sql, new Object[]{username});
            String digestedPassword = this.digestEncodedPassword(encodedPsw, values);
            if (!values.get(this.passwordFieldName).equals(digestedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            return this.createHandlerResult((Credential)transformedCredential, this.principalFactory.createPrincipal(username), null);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }

    protected String digestEncodedPassword(String encodedPassword, Map<String, Object> values) {
        DefaultHashService hashService = new DefaultHashService();
        if (StringUtils.isNotBlank((CharSequence)this.staticSalt)) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)this.staticSalt));
        }
        hashService.setHashAlgorithmName(this.algorithmName);
        Long numOfIterations = this.numberOfIterations;
        if (values.containsKey(this.numberOfIterationsFieldName)) {
            String longAsStr = values.get(this.numberOfIterationsFieldName).toString();
            numOfIterations = Long.valueOf(longAsStr);
        }
        hashService.setHashIterations(numOfIterations.intValue());
        if (!values.containsKey(this.saltFieldName)) {
            throw new RuntimeException("Specified field name for salt does not exist in the results");
        }
        String dynaSalt = values.get(this.saltFieldName).toString();
        HashRequest request = new HashRequest.Builder().setSalt((Object)dynaSalt).setSource((Object)encodedPassword).build();
        return hashService.computeHash(request).toHex();
    }

    public final void setStaticSalt(String staticSalt) {
        this.staticSalt = staticSalt;
    }

    public final void setPasswordFieldName(String passwordFieldName) {
        this.passwordFieldName = passwordFieldName;
    }

    public final void setSaltFieldName(String saltFieldName) {
        this.saltFieldName = saltFieldName;
    }

    public final void setNumberOfIterationsFieldName(String numberOfIterationsFieldName) {
        this.numberOfIterationsFieldName = numberOfIterationsFieldName;
    }

    public final void setNumberOfIterations(long numberOfIterations) {
        this.numberOfIterations = numberOfIterations;
    }
}

