/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;

public final class JpaTicketRegistry
extends AbstractDistributedTicketRegistry {
    @NotNull
    @PersistenceContext
    private EntityManager entityManager;

    public void updateTicket(Ticket ticket) {
        this.entityManager.merge((Object)ticket);
        this.logger.debug("Updated ticket [{}].", (Object)ticket);
    }

    public void addTicket(Ticket ticket) {
        this.entityManager.persist((Object)ticket);
        this.logger.debug("Added ticket [{}] to registry.", (Object)ticket);
    }

    public boolean deleteTicket(String ticketId) {
        Ticket ticket = this.getRawTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof ServiceTicket) {
            this.removeTicket(ticket);
            this.logger.debug("Deleted ticket [{}] from the registry.", (Object)ticket);
            return true;
        }
        this.deleteTicketAndChildren(ticket);
        this.logger.debug("Deleted ticket [{}] and its children from the registry.", (Object)ticket);
        return true;
    }

    private void deleteTicketAndChildren(Ticket ticket) {
        List ticketGrantingTicketImpls = this.entityManager.createQuery("select t from TicketGrantingTicketImpl t where t.ticketGrantingTicket.id = :id", TicketGrantingTicketImpl.class).setLockMode(LockModeType.PESSIMISTIC_WRITE).setParameter("id", (Object)ticket.getId()).getResultList();
        List serviceTicketImpls = this.entityManager.createQuery("select s from ServiceTicketImpl s where s.ticketGrantingTicket.id = :id", ServiceTicketImpl.class).setParameter("id", (Object)ticket.getId()).getResultList();
        for (ServiceTicketImpl s : serviceTicketImpls) {
            this.removeTicket((Ticket)s);
        }
        for (TicketGrantingTicketImpl t : ticketGrantingTicketImpls) {
            this.deleteTicketAndChildren((Ticket)t);
        }
        this.removeTicket(ticket);
    }

    private void removeTicket(Ticket ticket) {
        try {
            if (this.logger.isDebugEnabled()) {
                Date creationDate = new Date(ticket.getCreationTime());
                this.logger.debug("Removing Ticket [{}] created: {}", (Object)ticket, (Object)creationDate.toString());
            }
            this.entityManager.remove((Object)ticket);
        }
        catch (Exception e) {
            this.logger.error("Error removing {} from registry.", (Object)ticket, (Object)e);
        }
    }

    public Ticket getTicket(String ticketId) {
        return this.getProxiedTicketInstance(this.getRawTicket(ticketId));
    }

    private Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith("TGT") || ticketId.startsWith("PGT")) {
                return (Ticket)this.entityManager.find(TicketGrantingTicketImpl.class, (Object)ticketId);
            }
            return (Ticket)this.entityManager.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.logger.error("Error getting ticket {} from registry.", (Object)ticketId, (Object)e);
            return null;
        }
    }

    public Collection<Ticket> getTickets() {
        List tgts = this.entityManager.createQuery("select t from TicketGrantingTicketImpl t", TicketGrantingTicketImpl.class).getResultList();
        List sts = this.entityManager.createQuery("select s from ServiceTicketImpl s", ServiceTicketImpl.class).getResultList();
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        tickets.addAll(tgts);
        tickets.addAll(sts);
        return tickets;
    }

    protected boolean needsCallback() {
        return false;
    }

    public int sessionCount() {
        return this.countToInt(this.entityManager.createQuery("select count(t) from TicketGrantingTicketImpl t").getSingleResult());
    }

    public int serviceTicketCount() {
        return this.countToInt(this.entityManager.createQuery("select count(t) from ServiceTicketImpl t").getSingleResult());
    }

    private int countToInt(Object result) {
        int intval = result instanceof Long ? ((Long)result).intValue() : (result instanceof Integer ? ((Integer)result).intValue() : ((Number)result).intValue());
        return intval;
    }
}

