/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.AbstractPoolMonitor;
import org.jasig.cas.monitor.StatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DataSourceMonitor
extends AbstractPoolMonitor {
    @NotNull
    private final JdbcTemplate jdbcTemplate;
    @NotNull
    private String validationQuery;

    public DataSourceMonitor(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setValidationQuery(String query) {
        this.validationQuery = query;
    }

    protected StatusCode checkPool() throws Exception {
        return (StatusCode)this.jdbcTemplate.query(this.validationQuery, (ResultSetExtractor)new ResultSetExtractor<StatusCode>(){

            public StatusCode extractData(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return StatusCode.OK;
                }
                return StatusCode.WARN;
            }
        });
    }

    protected int getIdleCount() {
        return -1;
    }

    protected int getActiveCount() {
        return -1;
    }
}

