/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.LdapEncoder;

public final class LdapUtils {
    private static final Logger logger = LoggerFactory.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static String getFilterWithValues(String filter, String userName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String newFilter = filter;
        properties.put("%u", userName);
        String[] userDomain = userName.split("@");
        properties.put("%U", userDomain[0]);
        if (userDomain.length > 1) {
            properties.put("%d", userDomain[1]);
            String[] dcArray = userDomain[1].split("\\.");
            int i = 0;
            while (i < dcArray.length) {
                properties.put("%" + (i + 1), dcArray[dcArray.length - 1 - i]);
                ++i;
            }
        }
        for (String key : properties.keySet()) {
            String value = LdapEncoder.nameEncode((String)((String)properties.get(key)));
            newFilter = newFilter.replaceAll(key, Matcher.quoteReplacement(value));
        }
        return newFilter;
    }

    public static void closeContext(DirContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ex) {
                logger.warn("Could not close context", (Throwable)ex);
            }
        }
    }
}

