/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.util.LdapUtils;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public final class DefaultLdapServiceMapper
implements LdapRegisteredServiceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapServiceMapper.class);
    @NotNull
    private String objectClass = "casRegisteredService";
    @NotNull
    private String serviceIdAttribute = "casServiceUrlPattern";
    @NotNull
    private String idAttribute = "uid";
    @NotNull
    private String serviceDescriptionAttribute = "description";
    @NotNull
    private String serviceNameAttribute = "cn";
    @NotNull
    private String serviceEnabledAttribute = "casServiceEnabled";
    @NotNull
    private String serviceSsoEnabledAttribute = "casServiceSsoEnabled";
    @NotNull
    private String serviceAnonymousAccessAttribute = "casServiceAnonymousAccess";
    @NotNull
    private String serviceAllowedToProxyAttribute = "casServiceAllowedToProxy";
    @NotNull
    private String serviceThemeAttribute = "casServiceTheme";
    @NotNull
    private String usernameAttribute = "casUsernameAttribute";
    @NotNull
    private String serviceAllowedAttributesAttribute = "casAllowedAttributes";
    @NotNull
    private String ignoreAttributesAttribute = "casIgnoreAttributes";
    @NotNull
    private String evaluationOrderAttribute = "casEvaluationOrder";
    @NotNull
    private String requiredHandlersAttribute = "casRequiredHandlers";

    @Override
    public LdapEntry mapFromRegisteredService(String dn, RegisteredService svc) {
        if (svc.getId() == Long.MAX_VALUE) {
            ((AbstractRegisteredService)svc).setId(System.nanoTime());
        }
        String newDn = this.getDnForRegisteredService(dn, svc);
        LOGGER.debug("Creating entry {}", (Object)newDn);
        ArrayList<LdapAttribute> attrs = new ArrayList<LdapAttribute>();
        attrs.add(new LdapAttribute(this.idAttribute, new String[]{String.valueOf(svc.getId())}));
        attrs.add(new LdapAttribute(this.serviceIdAttribute, new String[]{svc.getServiceId()}));
        attrs.add(new LdapAttribute(this.serviceNameAttribute, new String[]{svc.getName()}));
        attrs.add(new LdapAttribute(this.serviceDescriptionAttribute, new String[]{svc.getDescription()}));
        attrs.add(new LdapAttribute(this.serviceEnabledAttribute, new String[]{Boolean.toString(svc.isEnabled()).toUpperCase()}));
        attrs.add(new LdapAttribute(this.serviceAllowedToProxyAttribute, new String[]{Boolean.toString(svc.isAllowedToProxy()).toUpperCase()}));
        attrs.add(new LdapAttribute(this.serviceAnonymousAccessAttribute, new String[]{Boolean.toString(svc.isAnonymousAccess()).toUpperCase()}));
        attrs.add(new LdapAttribute(this.serviceSsoEnabledAttribute, new String[]{Boolean.toString(svc.isSsoEnabled()).toUpperCase()}));
        attrs.add(new LdapAttribute(this.ignoreAttributesAttribute, new String[]{Boolean.toString(svc.isAnonymousAccess()).toUpperCase()}));
        attrs.add(new LdapAttribute(this.evaluationOrderAttribute, new String[]{String.valueOf(svc.getEvaluationOrder())}));
        attrs.add(new LdapAttribute(this.serviceThemeAttribute, new String[]{svc.getTheme()}));
        attrs.add(new LdapAttribute(this.usernameAttribute, new String[]{svc.getUsernameAttribute()}));
        if (svc.getAllowedAttributes().size() > 0) {
            attrs.add(new LdapAttribute(this.serviceAllowedAttributesAttribute, svc.getAllowedAttributes().toArray(new String[0])));
        }
        if (svc.getRequiredHandlers().size() > 0) {
            attrs.add(new LdapAttribute(this.requiredHandlersAttribute, svc.getRequiredHandlers().toArray(new String[0])));
        }
        attrs.add(new LdapAttribute("objectClass", new String[]{this.objectClass}));
        return new LdapEntry(newDn, attrs);
    }

    @Override
    public RegisteredService mapToRegisteredService(LdapEntry entry) {
        LdapAttribute attr = entry.getAttribute(this.serviceIdAttribute);
        if (attr != null) {
            AbstractRegisteredService s = this.getRegisteredService(attr.getStringValue());
            if (s != null) {
                s.setId(LdapUtils.getLong(entry, this.idAttribute, Long.valueOf(entry.getDn().hashCode())).longValue());
                s.setServiceId(LdapUtils.getString(entry, this.serviceIdAttribute));
                s.setName(LdapUtils.getString(entry, this.serviceNameAttribute));
                s.setDescription(LdapUtils.getString(entry, this.serviceDescriptionAttribute));
                s.setEnabled(LdapUtils.getBoolean(entry, this.serviceEnabledAttribute).booleanValue());
                s.setTheme(LdapUtils.getString(entry, this.serviceThemeAttribute));
                s.setEvaluationOrder(LdapUtils.getLong(entry, this.evaluationOrderAttribute).intValue());
                s.setUsernameAttribute(LdapUtils.getString(entry, this.usernameAttribute));
                s.setAllowedToProxy(LdapUtils.getBoolean(entry, this.serviceAllowedToProxyAttribute).booleanValue());
                s.setAnonymousAccess(LdapUtils.getBoolean(entry, this.serviceAnonymousAccessAttribute).booleanValue());
                s.setSsoEnabled(LdapUtils.getBoolean(entry, this.serviceSsoEnabledAttribute).booleanValue());
                s.setAllowedAttributes(new ArrayList<String>(this.getMultiValuedAttributeValues(entry, this.serviceAllowedAttributesAttribute)));
                s.setIgnoreAttributes(LdapUtils.getBoolean(entry, this.ignoreAttributesAttribute).booleanValue());
                s.setRequiredHandlers(new HashSet<String>(this.getMultiValuedAttributeValues(entry, this.requiredHandlersAttribute)));
            }
            return s;
        }
        return null;
    }

    @Override
    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    @Override
    public String getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }

    public void setServiceIdAttribute(String serviceIdAttribute) {
        this.serviceIdAttribute = serviceIdAttribute;
    }

    public void setServiceDescriptionAttribute(String serviceDescriptionAttribute) {
        this.serviceDescriptionAttribute = serviceDescriptionAttribute;
    }

    public void setServiceNameAttribute(String serviceNameAttribute) {
        this.serviceNameAttribute = serviceNameAttribute;
    }

    public void setServiceEnabledAttribute(String serviceEnabledAttribute) {
        this.serviceEnabledAttribute = serviceEnabledAttribute;
    }

    public void setServiceSsoEnabledAttribute(String serviceSsoEnabledAttribute) {
        this.serviceSsoEnabledAttribute = serviceSsoEnabledAttribute;
    }

    public void setServiceAnonymousAccessAttribute(String serviceAnonymousAccessAttribute) {
        this.serviceAnonymousAccessAttribute = serviceAnonymousAccessAttribute;
    }

    public void setServiceAllowedToProxyAttribute(String serviceAllowedToProxyAttribute) {
        this.serviceAllowedToProxyAttribute = serviceAllowedToProxyAttribute;
    }

    public void setServiceThemeAttribute(String serviceThemeAttribute) {
        this.serviceThemeAttribute = serviceThemeAttribute;
    }

    public void setServiceAllowedAttributesAttribute(String serviceAllowedAttributesAttribute) {
        this.serviceAllowedAttributesAttribute = serviceAllowedAttributesAttribute;
    }

    public void setIgnoreAttributesAttribute(String ignoreAttributesAttribute) {
        this.ignoreAttributesAttribute = ignoreAttributesAttribute;
    }

    public void setRequiredHandlersAttribute(String handlers) {
        this.requiredHandlersAttribute = handlers;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setEvaluationOrderAttribute(String evaluationOrderAttribute) {
        this.evaluationOrderAttribute = evaluationOrderAttribute;
    }

    @Override
    public String getDnForRegisteredService(String parentDn, RegisteredService svc) {
        return String.format("%s=%s,%s", this.idAttribute, svc.getId(), parentDn);
    }

    private boolean isValidRegexPattern(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug("Failed to identify [{}] as a regular expression", (Object)pattern);
            return false;
        }
        return true;
    }

    private Collection<String> getMultiValuedAttributeValues(@NotNull LdapEntry entry, @NotNull String attrName) {
        LdapAttribute attrs = entry.getAttribute(attrName);
        if (attrs != null) {
            return attrs.getStringValues();
        }
        return Collections.emptyList();
    }

    private AbstractRegisteredService getRegisteredService(@NotNull String id) {
        if (this.isValidRegexPattern(id)) {
            return new RegexRegisteredService();
        }
        if (new AntPathMatcher().isPattern(id)) {
            return new RegisteredServiceImpl();
        }
        return null;
    }
}

