/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.support;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.jasig.cas.Message;
import org.jasig.cas.authentication.support.DefaultAccountStateHandler;
import org.jasig.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.ldaptive.LdapAttribute;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationResponse;

public class OptionalWarningAccountStateHandler
extends DefaultAccountStateHandler {
    @NotNull
    private String warningAttributeName;
    @NotNull
    private String warningAttributeValue;
    private boolean displayWarningOnMatch = true;

    public void setWarningAttributeName(String warningAttributeName) {
        this.warningAttributeName = warningAttributeName;
    }

    public void setWarningAttributeValue(String warningAttributeValue) {
        this.warningAttributeValue = warningAttributeValue;
    }

    public void setDisplayWarningOnMatch(boolean displayWarningOnMatch) {
        this.displayWarningOnMatch = displayWarningOnMatch;
    }

    @Override
    protected void handleWarning(AccountState.Warning warning, AuthenticationResponse response, LdapPasswordPolicyConfiguration configuration, List<Message> messages) {
        LdapAttribute attribute = response.getLdapEntry().getAttribute(this.warningAttributeName);
        boolean matches = false;
        if (attribute != null) {
            this.logger.debug("Found warning attribute {} with value {}", (Object)attribute.getName(), (Object)attribute.getStringValue());
            matches = this.warningAttributeValue.equals(attribute.getStringValue());
        }
        this.logger.debug("matches={}, displayWarningOnMatch={}", (Object)matches, (Object)this.displayWarningOnMatch);
        if (this.displayWarningOnMatch == matches) {
            super.handleWarning(warning, response, configuration, messages);
        }
    }
}

