/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JRadiusServerImpl
implements RadiusServer {
    private static final Logger LOG = LoggerFactory.getLogger(JRadiusServerImpl.class);
    private static final RadiusAuthenticator DEFAULT_RADIUS_AUTHENTICATOR = new PAPAuthenticator();
    private static final int DEFAULT_AUTHENTICATION_PORT = 1812;
    private static final int DEFAULT_ACCOUNTING_PORT = 1813;
    private static final int DEFAULT_SOCKET_TIMEOUT = 5;
    private static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private final int accountingPort;
    private final int authenticationPort;
    private final int socketTimeout;
    private final InetAddress inetAddress;
    private final String sharedSecret;
    private final int retries;
    private final RadiusAuthenticator radiusAuthenticator;

    static {
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
    }

    public JRadiusServerImpl(String hostName, String sharedSecret) throws UnknownHostException {
        this(hostName, sharedSecret, DEFAULT_RADIUS_AUTHENTICATOR, 1812);
    }

    public JRadiusServerImpl(String hostName, String sharedSecret, RadiusAuthenticator radiusAuthenticator) throws UnknownHostException {
        this(hostName, sharedSecret, radiusAuthenticator, 1812);
    }

    public JRadiusServerImpl(String hostName, String sharedSecret, RadiusAuthenticator radiusAuthenticator, int authenticationPort) throws UnknownHostException {
        this(hostName, sharedSecret, radiusAuthenticator, authenticationPort, 1813);
    }

    public JRadiusServerImpl(String hostName, String sharedSecret, RadiusAuthenticator radiusAuthenticator, int authenticationPort, int accountingPort) throws UnknownHostException {
        this(hostName, sharedSecret, radiusAuthenticator, authenticationPort, accountingPort, 5, 3);
    }

    public JRadiusServerImpl(String hostName, String sharedSecret, RadiusAuthenticator radiusAuthenticator, int authenticationPort, int accountingPort, int socketTimeout, int retries) throws UnknownHostException {
        this.sharedSecret = sharedSecret;
        this.authenticationPort = authenticationPort;
        this.accountingPort = accountingPort;
        this.socketTimeout = socketTimeout;
        this.retries = retries;
        this.radiusAuthenticator = radiusAuthenticator;
        this.inetAddress = InetAddress.getByName(hostName);
    }

    @Override
    public boolean authenticate(UsernamePasswordCredentials usernamePasswordCredentials) {
        block4: {
            RadiusClient radiusClient = this.getNewRadiusClient();
            AttributeList attributeList = new AttributeList();
            attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)usernamePasswordCredentials.getUsername())));
            attributeList.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)usernamePasswordCredentials.getPassword())));
            AccessRequest request = new AccessRequest(radiusClient, attributeList);
            RadiusResponse response = radiusClient.authenticate(request, this.radiusAuthenticator, this.retries);
            if (!(response instanceof AccessAccept)) break block4;
            LOG.debug("Authentication request suceeded for host:" + this.inetAddress.getCanonicalHostName() + " and username " + usernamePasswordCredentials.getUsername());
            return true;
        }
        try {
            LOG.debug("Authentication request failed for host:" + this.inetAddress.getCanonicalHostName() + " and username " + usernamePasswordCredentials.getUsername());
            return false;
        }
        catch (UnknownAttributeException e) {
            throw new IllegalArgumentException("Passed an unknown attribute to RADIUS client: " + e.getMessage());
        }
        catch (RadiusException e) {
            throw new IllegalStateException("Received response that puts RadiusClient into illegal state: " + e.getMessage());
        }
    }

    private RadiusClient getNewRadiusClient() {
        return new RadiusClient(this.inetAddress, this.sharedSecret, this.authenticationPort, this.accountingPort, this.socketTimeout);
    }
}

