/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication.principal;

import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.DefaultResponse;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService$AjcClosure1;
import org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService$AjcClosure3;
import org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService$AjcClosure5;
import org.jasig.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.jasig.cas.support.saml.util.GoogleSaml20ObjectBuilder;
import org.jasig.cas.util.ISOStandardDateFormat;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jdom.Document;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.springframework.util.StringUtils;

public class GoogleAccountsService
extends AbstractWebApplicationService {
    private static final long serialVersionUID = 6678711809842282833L;
    private static final int INFLATED_BYTE_ARRAY_LENGTH = 10000;
    private static final int DEFLATED_BYTE_ARRAY_BUFFER_LENGTH = 1024;
    private static final int SAML_RESPONSE_RANDOM_ID_LENGTH = 20;
    private static final int SAML_RESPONSE_ID_LENGTH = 40;
    private static final int HEX_HIGH_BITS_BITWISE_FLAG = 15;
    private static final int HEX_RIGHT_SHIFT_COEFFICIENT = 4;
    private static final GoogleSaml20ObjectBuilder BUILDER;
    private final String relayState;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final String requestId;
    private final ServicesManager servicesManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected GoogleAccountsService(String id, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, ServicesManager servicesManager) {
        this(id, id, null, relayState, requestId, privateKey, publicKey, servicesManager);
    }

    protected GoogleAccountsService(String id, String originalUrl, String artifactId, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, ServicesManager servicesManager) {
        super(id, originalUrl, artifactId);
        this.relayState = relayState;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.requestId = requestId;
        this.servicesManager = servicesManager;
    }

    public static GoogleAccountsService createServiceFrom(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, ServicesManager servicesManager) {
        HttpServletRequest httpServletRequest = request;
        PrivateKey privateKey2 = privateKey;
        PublicKey publicKey2 = publicKey;
        ServicesManager servicesManager2 = servicesManager;
        Object[] objectArray = new Object[]{httpServletRequest, privateKey2, publicKey2, servicesManager2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{httpServletRequest, privateKey2, publicKey2, servicesManager2, joinPoint};
        return (GoogleAccountsService)((Object)TraceLogAspect.aspectOf().traceMethod(new GoogleAccountsService$AjcClosure1(objectArray2).linkClosureAndJoinPoint(65536)));
    }

    public Response getResponse(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Response)TraceLogAspect.aspectOf().traceMethod(new GoogleAccountsService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean isLoggedOutAlready() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new GoogleAccountsService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private String constructSamlResponse() {
        DateTime currentDateTime = DateTime.parse((String)new ISOStandardDateFormat().getCurrentDateAndTime());
        DateTime notBeforeIssueInstant = DateTime.parse((String)"2003-04-17T00:46:02Z");
        RegisteredService svc = this.servicesManager.findServiceBy((Service)this);
        String userId = svc.getUsernameAttributeProvider().resolveUsername(this.getPrincipal(), (Service)this);
        org.opensaml.saml.saml2.core.Response response = BUILDER.newResponse(BUILDER.generateSecureRandomId(), currentDateTime, this.getId(), (WebApplicationService)this);
        response.setStatus(BUILDER.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null));
        AuthnStatement authnStatement = BUILDER.newAuthnStatement("urn:oasis:names:tc:SAML:2.0:ac:classes:Password", currentDateTime);
        Assertion assertion = BUILDER.newAssertion(authnStatement, "https://www.opensaml.org/IDP", notBeforeIssueInstant, BUILDER.generateSecureRandomId());
        Conditions conditions = BUILDER.newConditions(notBeforeIssueInstant, currentDateTime, this.getId());
        assertion.setConditions(conditions);
        Subject subject = BUILDER.newSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", userId, this.getId(), currentDateTime, this.requestId);
        assertion.setSubject(subject);
        response.getAssertions().add(assertion);
        StringWriter writer = new StringWriter();
        BUILDER.marshalSamlXmlObject((XMLObject)response, writer);
        String result = writer.toString();
        this.logger.debug("Generated Google SAML response: {}", (Object)result);
        return result;
    }

    static {
        GoogleAccountsService.ajc$preClinit();
        BUILDER = new GoogleSaml20ObjectBuilder();
    }

    static final /* synthetic */ GoogleAccountsService createServiceFrom_aroundBody0(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, ServicesManager servicesManager, JoinPoint joinPoint) {
        String relayState = request.getParameter("RelayState");
        String xmlRequest = BUILDER.decodeSamlAuthnRequest(request.getParameter("SAMLRequest"));
        if (!StringUtils.hasText((String)xmlRequest)) {
            return null;
        }
        Document document = AbstractSaml20ObjectBuilder.constructDocumentFromXml(xmlRequest);
        if (document == null) {
            return null;
        }
        Element root = document.getRootElement();
        String assertionConsumerServiceUrl = root.getAttributeValue("AssertionConsumerServiceURL");
        String requestId = root.getAttributeValue("ID");
        return new GoogleAccountsService(assertionConsumerServiceUrl, relayState, requestId, privateKey, publicKey, servicesManager);
    }

    static final /* synthetic */ Response getResponse_aroundBody2(GoogleAccountsService ajc$this, String ticketId, JoinPoint joinPoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String samlResponse = ajc$this.constructSamlResponse();
        String signedResponse = BUILDER.signSamlResponse(samlResponse, ajc$this.privateKey, ajc$this.publicKey);
        parameters.put("SAMLResponse", signedResponse);
        parameters.put("RelayState", ajc$this.relayState);
        return DefaultResponse.getPostResponse((String)ajc$this.getOriginalUrl(), parameters);
    }

    static final /* synthetic */ boolean isLoggedOutAlready_aroundBody4(GoogleAccountsService ajc$this, JoinPoint joinPoint) {
        return true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GoogleAccountsService.java", GoogleAccountsService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createServiceFrom", "org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService", "javax.servlet.http.HttpServletRequest:java.security.PrivateKey:java.security.PublicKey:org.jasig.cas.services.ServicesManager", "request:privateKey:publicKey:servicesManager", "", "org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService"), 131);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResponse", "org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService", "java.lang.String", "ticketId", "", "org.jasig.cas.authentication.principal.Response"), 156);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLoggedOutAlready", "org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService", "", "", "", "boolean"), 173);
    }
}

