/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.DefaultResponse;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.support.saml.authentication.principal.SamlService$AjcClosure1;
import org.jasig.cas.support.saml.authentication.principal.SamlService$AjcClosure3;
import org.jasig.cas.support.saml.authentication.principal.SamlService$AjcClosure5;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SamlService
extends AbstractWebApplicationService {
    private static final Logger LOGGER;
    private static final long serialVersionUID = -6867572626767140223L;
    private static final String CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE = "<AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE = "</AssertionArtifact>";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";
    private static final int CONST_REQUEST_ID_LENGTH = 11;
    private String requestId;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected SamlService(String id) {
        super(id, id, null);
    }

    protected SamlService(String id, String originalUrl, String artifactId, String requestId) {
        super(id, originalUrl, artifactId);
        this.requestId = requestId;
    }

    public String getRequestID() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new SamlService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public static SamlService createServiceFrom(HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)httpServletRequest);
        Object[] objectArray = new Object[]{httpServletRequest, joinPoint};
        return (SamlService)((Object)TraceLogAspect.aspectOf().traceMethod(new SamlService$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536)));
    }

    public Response getResponse(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Response)TraceLogAspect.aspectOf().traceMethod(new SamlService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected static String extractRequestId(String requestBody) {
        if (!requestBody.contains("RequestID")) {
            LOGGER.debug("Request body does not contain a request id");
            return null;
        }
        try {
            int position = requestBody.indexOf("RequestID=\"") + 11;
            int nextPosition = requestBody.indexOf(34, position);
            return requestBody.substring(position, nextPosition);
        }
        catch (Exception e) {
            LOGGER.debug("Exception parsing RequestID from request.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getRequestBody(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            if (reader == null) {
                LOGGER.debug("Request body could not be read because it's empty.");
                String string2 = null;
                return string2;
            }
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.trace("Could not obtain the saml request body from the http request", (Throwable)e);
            return null;
        }
    }

    static {
        SamlService.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SamlService.class);
    }

    static final /* synthetic */ String getRequestID_aroundBody0(SamlService ajc$this, JoinPoint joinPoint) {
        return ajc$this.requestId;
    }

    static final /* synthetic */ SamlService createServiceFrom_aroundBody2(HttpServletRequest request, JoinPoint joinPoint) {
        String requestId;
        String artifactId;
        String service = request.getParameter("TARGET");
        String requestBody = SamlService.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            LOGGER.debug("Request does not specify a {} or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlService.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            String tagEnd;
            String tagStart;
            if (requestBody.contains(CONST_START_ARTIFACT_XML_TAG)) {
                tagStart = CONST_START_ARTIFACT_XML_TAG;
                tagEnd = CONST_END_ARTIFACT_XML_TAG;
            } else {
                tagStart = CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE;
                tagEnd = CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE;
            }
            int startTagLocation = requestBody.indexOf(tagStart);
            int artifactStartLocation = startTagLocation + tagStart.length();
            int endTagLocation = requestBody.indexOf(tagEnd);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
            requestId = SamlService.extractRequestId(requestBody);
        } else {
            artifactId = null;
            requestId = null;
        }
        LOGGER.debug("Attempted to extract Request from HttpServletRequest. Results:");
        LOGGER.debug("Request Body: {}", (Object)requestBody);
        LOGGER.debug("Extracted ArtifactId: {}", artifactId);
        LOGGER.debug("Extracted Request Id: {}", requestId);
        return new SamlService(id, service, artifactId, requestId);
    }

    static final /* synthetic */ Response getResponse_aroundBody4(SamlService ajc$this, String ticketId, JoinPoint joinPoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SAMLart", ticketId);
        return DefaultResponse.getRedirectResponse((String)ajc$this.getOriginalUrl(), parameters);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SamlService.java", SamlService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestID", "org.jasig.cas.support.saml.authentication.principal.SamlService", "", "", "", "java.lang.String"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createServiceFrom", "org.jasig.cas.support.saml.authentication.principal.SamlService", "javax.servlet.http.HttpServletRequest", "request", "", "org.jasig.cas.support.saml.authentication.principal.SamlService"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResponse", "org.jasig.cas.support.saml.authentication.principal.SamlService", "java.lang.String", "ticketId", "", "org.jasig.cas.authentication.principal.Response"), 145);
    }
}

