/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bouncycastle.util.encoders.Hex;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure1;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure11;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure3;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure5;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure7;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder$AjcClosure9;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSamlObjectBuilder {
    protected static final String DEFAULT_ELEMENT_NAME_FIELD = "DEFAULT_ELEMENT_NAME";
    protected static final String DEFAULT_ELEMENT_LOCAL_NAME_FIELD = "DEFAULT_ELEMENT_LOCAL_NAME";
    private static final int RANDOM_ID_SIZE = 16;
    private static final String SIGNATURE_FACTORY_PROVIDER_CLASS = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public final <T extends SAMLObject> T newSamlObject(Class<T> objectType) {
        Class<T> clazz = objectType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, clazz);
        Object[] objectArray = new Object[]{this, clazz, joinPoint};
        return (T)((SAMLObject)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public QName getSamlObjectQName(Class objectType) throws RuntimeException {
        Class clazz = objectType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)clazz);
        Object[] objectArray = new Object[]{this, clazz, joinPoint};
        return (QName)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private <T extends SAMLObject> T newSamlObject(Class<T> objectType, QName qName) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
        if (builder == null) {
            throw new IllegalStateException("No SAMLObjectBuilder registered for class " + objectType.getName());
        }
        return (T)((SAMLObject)objectType.cast(builder.buildObject()));
    }

    protected final XSString newAttributeValue(Object value, QName elementName) {
        XSStringBuilder attrValueBuilder = new XSStringBuilder();
        XSString stringValue = (XSString)attrValueBuilder.buildObject(elementName, XSString.TYPE_NAME);
        if (value instanceof String) {
            stringValue.setValue((String)value);
        } else {
            stringValue.setValue(value.toString());
        }
        return stringValue;
    }

    public String generateSecureRandomId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String marshalSamlXmlObject(XMLObject object, StringWriter writer) {
        XMLObject xMLObject = object;
        StringWriter stringWriter = writer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)xMLObject, (Object)stringWriter);
        Object[] objectArray = new Object[]{this, xMLObject, stringWriter, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final String signSamlResponse(String samlResponse, PrivateKey privateKey, PublicKey publicKey) {
        String string = samlResponse;
        PrivateKey privateKey2 = privateKey;
        PublicKey publicKey2 = publicKey;
        Object[] objectArray = new Object[]{string, privateKey2, publicKey2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, privateKey2, publicKey2, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public static Document constructDocumentFromXml(String xmlString) {
        String string = xmlString;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        return (Document)TraceLogAspect.aspectOf().traceMethod(new AbstractSamlObjectBuilder$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536));
    }

    private org.jdom.Element signSamlElement(org.jdom.Element element, PrivateKey privKey, PublicKey pubKey) {
        try {
            SignatureMethod signatureMethod;
            String providerName = System.getProperty("jsr105Provider", SIGNATURE_FACTORY_PROVIDER_CLASS);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            List<Transform> envelopedTransform = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), envelopedTransform, null, null);
            if (pubKey instanceof DSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
            } else if (pubKey instanceof RSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            } else {
                throw new RuntimeException("Error signing SAML element: Unsupported type of key");
            }
            CanonicalizationMethod canonicalizationMethod = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(ref));
            KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
            KeyValue keyValuePair = keyInfoFactory.newKeyValue(pubKey);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValuePair));
            Element w3cElement = this.toDom(element);
            DOMSignContext dsc = new DOMSignContext(privKey, (Node)w3cElement);
            Node xmlSigInsertionPoint = AbstractSamlObjectBuilder.getXmlSignatureInsertLocation(w3cElement);
            dsc.setNextSibling(xmlSigInsertionPoint);
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            return AbstractSamlObjectBuilder.toJdom(w3cElement);
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing SAML element: " + e.getMessage(), e);
        }
    }

    private static Node getXmlSignatureInsertLocation(Element elem) {
        Node insertLocation = null;
        NodeList nodeList = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions");
        if (nodeList.getLength() != 0) {
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        } else {
            nodeList = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        }
        return insertLocation;
    }

    private Element toDom(org.jdom.Element element) {
        return this.toDom(element.getDocument()).getDocumentElement();
    }

    private org.w3c.dom.Document toDom(Document doc) {
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            StringWriter elemStrWriter = new StringWriter();
            xmlOutputter.output(doc, (Writer)elemStrWriter);
            byte[] xmlBytes = elemStrWriter.toString().getBytes(Charset.defaultCharset());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
        }
        catch (Exception e) {
            this.logger.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static org.jdom.Element toJdom(Element e) {
        return new DOMBuilder().build(e);
    }

    static {
        AbstractSamlObjectBuilder.ajc$preClinit();
    }

    static final /* synthetic */ SAMLObject newSamlObject_aroundBody0(AbstractSamlObjectBuilder ajc$this, Class objectType, JoinPoint joinPoint) {
        QName qName = ajc$this.getSamlObjectQName(objectType);
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
        if (builder == null) {
            throw new IllegalStateException("No SAMLObjectBuilder registered for class " + objectType.getName());
        }
        return (SAMLObject)objectType.cast(builder.buildObject(qName));
    }

    static final /* synthetic */ QName getSamlObjectQName_aroundBody2(AbstractSamlObjectBuilder ajc$this, Class objectType, JoinPoint joinPoint) {
        try {
            Field f = objectType.getField(DEFAULT_ELEMENT_NAME_FIELD);
            return (QName)f.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Cannot find field " + objectType.getName() + '.' + DEFAULT_ELEMENT_NAME_FIELD);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + objectType.getName() + '.' + DEFAULT_ELEMENT_NAME_FIELD);
        }
    }

    static final /* synthetic */ String generateSecureRandomId_aroundBody4(AbstractSamlObjectBuilder ajc$this, JoinPoint joinPoint) {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] buf = new byte[16];
            random.nextBytes(buf);
            return "_".concat(new String(Hex.encode((byte[])buf)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create secure random ID generator for SAML message IDs.", e);
        }
    }

    static final /* synthetic */ String marshalSamlXmlObject_aroundBody6(AbstractSamlObjectBuilder ajc$this, XMLObject object, StringWriter writer, JoinPoint joinPoint) {
        try {
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(object);
            if (marshaller == null) {
                throw new IllegalArgumentException("Cannot obtain marshaller for object " + object.getElementQName());
            }
            Element element = marshaller.marshall(object);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(element), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error has occurred while marshalling SAML object to xml", e);
        }
    }

    static final /* synthetic */ String signSamlResponse_aroundBody8(AbstractSamlObjectBuilder ajc$this, String samlResponse, PrivateKey privateKey, PublicKey publicKey, JoinPoint joinPoint) {
        Document doc = AbstractSamlObjectBuilder.constructDocumentFromXml(samlResponse);
        if (doc != null) {
            org.jdom.Element signedElement = ajc$this.signSamlElement(doc.getRootElement(), privateKey, publicKey);
            doc.setRootElement((org.jdom.Element)signedElement.detach());
            return new XMLOutputter().outputString(doc);
        }
        throw new RuntimeException("Error signing SAML Response: Null document");
    }

    static final /* synthetic */ Document constructDocumentFromXml_aroundBody10(String xmlString, JoinPoint joinPoint) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return builder.build((InputStream)new ByteArrayInputStream(xmlString.getBytes(Charset.defaultCharset())));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractSamlObjectBuilder.java", AbstractSamlObjectBuilder.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "newSamlObject", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "java.lang.Class", "objectType", "", "org.opensaml.saml.common.SAMLObject"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSamlObjectQName", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "java.lang.Class", "objectType", "java.lang.RuntimeException", "javax.xml.namespace.QName"), 126);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateSecureRandomId", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "", "", "", "java.lang.String"), 176);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "marshalSamlXmlObject", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "org.opensaml.core.xml.XMLObject:java.io.StringWriter", "object:writer", "", "java.lang.String"), 194);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "signSamlResponse", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "java.lang.String:java.security.PrivateKey:java.security.PublicKey", "samlResponse:privateKey:publicKey", "", "java.lang.String"), 224);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "constructDocumentFromXml", "org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder", "java.lang.String", "xmlString", "", "org.jdom.Document"), 243);
    }
}

