/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.flow.mdui;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.support.saml.web.flow.mdui.MetadataResolverAdapter;
import org.jasig.cas.support.saml.web.flow.mdui.SimpleMetadataUIInfo;
import org.jasig.cas.web.support.WebUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SamlMetadataUIParserAction
extends AbstractAction {
    public static final String ENTITY_ID_PARAMETER_NAME = "entityId";
    public static final String MDUI_FLOW_PARAMETER_NAME = "mduiContext";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final String entityIdParameterName;
    @NotNull
    private final MetadataResolverAdapter metadataAdapter;
    @Autowired
    @NotNull
    private ServicesManager servicesManager;

    public SamlMetadataUIParserAction(MetadataResolverAdapter metadataAdapter) {
        this(ENTITY_ID_PARAMETER_NAME, metadataAdapter);
    }

    public SamlMetadataUIParserAction(String entityIdParameterName, MetadataResolverAdapter metadataAdapter) {
        this.entityIdParameterName = entityIdParameterName;
        this.metadataAdapter = metadataAdapter;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String entityId = request.getParameter(this.entityIdParameterName);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.logger.debug("No entity id found for parameter [{}]", (Object)this.entityIdParameterName);
            return this.success();
        }
        SimpleWebApplicationServiceImpl service = new SimpleWebApplicationServiceImpl(entityId);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            this.logger.debug("Entity id [{}] is not recognized/allowed by the CAS service registry", (Object)entityId);
            throw new UnauthorizedServiceException("screen.service.error.message", "Entity " + entityId + " not recognized");
        }
        EntityDescriptor entityDescriptor = this.metadataAdapter.getEntityDescriptorForEntityId(entityId);
        if (entityDescriptor == null) {
            this.logger.debug("Entity descriptor not found for [{}]", (Object)entityId);
            return this.success();
        }
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor(entityDescriptor);
        if (spssoDescriptor == null) {
            this.logger.debug("SP SSO descriptor not found for [{}]", (Object)entityId);
            return this.success();
        }
        Extensions extensions = spssoDescriptor.getExtensions();
        List spExtensions = extensions.getUnknownXMLObjects(UIInfo.DEFAULT_ELEMENT_NAME);
        if (spExtensions.isEmpty()) {
            this.logger.debug("No extensions are found for [{}]", (Object)UIInfo.DEFAULT_ELEMENT_NAME.getNamespaceURI());
            return this.success();
        }
        SimpleMetadataUIInfo mdui = new SimpleMetadataUIInfo(registeredService);
        for (XMLObject obj : spExtensions) {
            if (!(obj instanceof UIInfo)) continue;
            UIInfo uiInfo = (UIInfo)obj;
            this.logger.debug("Found UI info for [{}] and added to flow context", (Object)entityId);
            mdui.setUIInfo(uiInfo);
        }
        requestContext.getFlowScope().put(MDUI_FLOW_PARAMETER_NAME, (Object)mdui);
        return this.success();
    }

    private SPSSODescriptor getSPSSODescriptor(EntityDescriptor entityDescriptor) {
        this.logger.debug("Locating SP SSO descriptor for SAML2 protocol...");
        SPSSODescriptor spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (spssoDescriptor == null) {
            this.logger.debug("Locating SP SSO descriptor for SAML11 protocol...");
            spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol");
        }
        if (spssoDescriptor == null) {
            this.logger.debug("Locating SP SSO descriptor for SAML1 protocol...");
            spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.0:protocol");
        }
        this.logger.debug("SP SSO descriptor resolved to be [{}]", (Object)spssoDescriptor);
        return spssoDescriptor;
    }
}

