/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.principal;

import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.AbstractPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredentials;

public final class SpnegoCredentialsToPrincipalResolver
extends AbstractPersonDirectoryCredentialsToPrincipalResolver {
    @NotNull
    private Transform transformPrincipalId = Transform.NONE;

    protected String extractPrincipalId(Credentials credentials) {
        SpnegoCredentials c = (SpnegoCredentials)credentials;
        switch (this.transformPrincipalId) {
            case UPPERCASE: {
                return c.getPrincipal().getId().toUpperCase(Locale.ENGLISH);
            }
            case LOWERCASE: {
                return c.getPrincipal().getId().toLowerCase(Locale.ENGLISH);
            }
        }
        return c.getPrincipal().getId();
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && SpnegoCredentials.class.equals(credentials.getClass());
    }

    public void setTransformPrincipalId(Transform transform) {
        this.transformPrincipalId = transform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transform {
        NONE,
        UPPERCASE,
        LOWERCASE;

    }
}

