/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import javax.validation.constraints.NotNull;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredentials;

public class NtlmAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private boolean loadBalance = true;
    @NotNull
    private String domainController = Config.getProperty((String)"jcifs.smb.client.domain");
    private String includePattern = null;

    /*
     * Enabled aggressive exception aggregation
     */
    protected final boolean doAuthentication(Credentials credentials) throws AuthenticationException {
        SpnegoCredentials ntlmCredentials = (SpnegoCredentials)credentials;
        byte[] src = ntlmCredentials.getInitToken();
        UniAddress dc = null;
        try {
            if (this.loadBalance) {
                if (this.includePattern != null) {
                    NbtAddress[] dcs = NbtAddress.getAllByName((String)this.domainController, (int)28, null, null);
                    int i = 0;
                    while (i < dcs.length) {
                        if (dcs[i].getHostAddress().matches(this.includePattern)) {
                            dc = new UniAddress((Object)dcs[i]);
                            break;
                        }
                        ++i;
                    }
                } else {
                    dc = new UniAddress((Object)NbtAddress.getByName((String)this.domainController, (int)28, null));
                }
            } else {
                dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            }
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            switch (src[8]) {
                case 1: {
                    this.log.debug("Type 1 received");
                    Type1Message type1 = new Type1Message(src);
                    Type2Message type2 = new Type2Message(type1, challenge, null);
                    this.log.debug("Type 2 returned. Setting next token.");
                    ntlmCredentials.setNextToken(type2.toByteArray());
                    return false;
                }
                case 3: {
                    this.log.debug("Type 3 received");
                    Type3Message type3 = new Type3Message(src);
                    byte[] lmResponse = type3.getLMResponse() == null ? new byte[]{} : type3.getLMResponse();
                    byte[] ntResponse = type3.getNTResponse() == null ? new byte[]{} : type3.getNTResponse();
                    NtlmPasswordAuthentication ntlm = new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
                    this.log.debug("Trying to authenticate " + type3.getUser() + " with domain controller");
                    try {
                        SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                        ntlmCredentials.setPrincipal((Principal)new SimplePrincipal(type3.getUser()));
                        return true;
                    }
                    catch (SmbAuthException sae) {
                        this.log.debug("Authentication failed", (Throwable)sae);
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BadCredentialsAuthenticationException((Throwable)e);
        }
        return false;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && SpnegoCredentials.class.equals(credentials.getClass());
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setDomainController(String domainController) {
        this.domainController = domainController;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }
}

