/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public final class CertUtils {
    public static final String X509_CERTIFICATE_TYPE = "X509";

    private CertUtils() {
    }

    public static boolean isExpired(X509CRL crl) {
        return CertUtils.isExpired(crl, new Date(System.currentTimeMillis()));
    }

    public static boolean isExpired(X509CRL crl, Date reference) {
        return reference.after(crl.getNextUpdate());
    }

    public static X509CRL fetchCRL(Resource resource) throws CRLException, IOException {
        InputStream in = resource.getURL().openStream();
        try {
            X509CRL x509CRL = (X509CRL)CertUtils.getCertificateFactory().generateCRL(in);
            return x509CRL;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String toString(X509Certificate cert) {
        return String.format("%s, SerialNumber=%s", cert.getSubjectDN(), cert.getSerialNumber());
    }

    public static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("X509 certificate type not supported by default provider.");
        }
    }
}

