/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.theme.AbstractThemeResolver;

public final class ServiceThemeResolver
extends AbstractThemeResolver {
    private ServicesManager servicesManager;
    private List<ArgumentExtractor> argumentExtractors;
    private Map<Pattern, String> overrides = new HashMap<Pattern, String>();

    public String resolveThemeName(HttpServletRequest request) {
        if (this.servicesManager == null) {
            return this.getDefaultThemeName();
        }
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (HttpServletRequest)request);
        RegisteredService rService = this.servicesManager.findServiceBy((Service)service);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return this.getDefaultThemeName();
        }
        for (Map.Entry<Pattern, String> entry : this.overrides.entrySet()) {
            if (!entry.getKey().matcher(userAgent).matches()) continue;
            request.setAttribute("isMobile", (Object)"true");
            request.setAttribute("browserType", (Object)entry.getValue());
            break;
        }
        return service != null && rService != null && StringUtils.hasText((String)rService.getTheme()) ? rService.getTheme() : this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setArgumentExtractors(List<ArgumentExtractor> argumentExtractors) {
        this.argumentExtractors = argumentExtractors;
    }

    public void setMobileBrowsers(Map<String, String> mobileOverrides) {
        this.overrides = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> entry : mobileOverrides.entrySet()) {
            this.overrides.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
    }
}

