/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.CasLoggerContextInitializer$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
public final class CasLoggerContextInitializer
implements ServletContextAware {
    private static AtomicBoolean INITIALIZED;
    private static final Logger LOGGER;
    private ServletContext context;
    private ServletContextListener loggerContext;
    private final String loggerContextPackageName;
    private final Resource logConfigurationFile;
    private final String logConfigurationField;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected CasLoggerContextInitializer() {
        this.loggerContext = null;
        this.loggerContextPackageName = null;
        this.logConfigurationField = null;
        this.logConfigurationFile = null;
    }

    public CasLoggerContextInitializer(@NotNull String loggerContextPackageName, @NotNull Resource logConfigurationFile, @NotNull String logConfigurationField) {
        this.loggerContextPackageName = loggerContextPackageName;
        this.logConfigurationField = logConfigurationField;
        this.logConfigurationFile = logConfigurationFile;
    }

    private void initialize() {
        try {
            if (!INITIALIZED.get() && this.loggerContext != null) {
                ServletContextEvent event = new ServletContextEvent(this.context);
                this.loggerContext.contextInitialized(event);
                LOGGER.debug("Initialized logging context via [{}]. Logs will be written to [{}]", (Object)this.loggerContext.getClass().getSimpleName(), (Object)this.logConfigurationFile);
                INITIALIZED.set(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new CasLoggerContextInitializer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private ServletContextListener prepareAndgetContextListener() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.loggerContextPackageName)) {
                Collection set = ClasspathHelper.forPackage((String)this.loggerContextPackageName, (ClassLoader[])new ClassLoader[0]);
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(set).setScanners(new Scanner[]{new SubTypesScanner()}));
                Set subTypesOf = reflections.getSubTypesOf(ServletContextListener.class);
                ServletContextListener loggingContext = (ServletContextListener)((Class)subTypesOf.iterator().next()).newInstance();
                this.context.setInitParameter(this.logConfigurationField, this.logConfigurationFile.getURI().toString());
                return loggingContext;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
        this.loggerContext = this.prepareAndgetContextListener();
        this.initialize();
    }

    static {
        CasLoggerContextInitializer.ajc$preClinit();
        INITIALIZED = new AtomicBoolean(false);
        LOGGER = LoggerFactory.getLogger(CasLoggerContextInitializer.class);
    }

    static final /* synthetic */ void destroy_aroundBody0(CasLoggerContextInitializer ajc$this, JoinPoint joinPoint) {
        try {
            if (INITIALIZED.get() && ajc$this.loggerContext != null) {
                ServletContextEvent event = new ServletContextEvent(ajc$this.context);
                LOGGER.debug("Destroying logging context and shutting it down");
                ajc$this.loggerContext.contextDestroyed(event);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CasLoggerContextInitializer.java", CasLoggerContextInitializer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.jasig.cas.util.CasLoggerContextInitializer", "", "", "", "void"), 119);
    }
}

