/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationSpecification;
import org.jasig.cas.web.DelegateController;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

public class ServiceValidateController
extends DelegateController {
    public static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "cas2ServiceFailureView";
    public static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "cas2ServiceSuccessView";
    @NotNull
    private ServicesManager servicesManager;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Class<?> validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
    @NotNull
    private ProxyHandler proxyHandler;
    @NotNull
    private String successView = "cas2ServiceSuccessView";
    @NotNull
    private String failureView = "cas2ServiceFailureView";
    @NotNull
    private ArgumentExtractor argumentExtractor;

    protected Credential getServiceCredentialsFromRequest(WebApplicationService service, HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
                this.verifyRegisteredServiceProperties(registeredService, (Service)service);
                return new HttpBasedServiceCredential(new URL(pgtUrl), registeredService);
            }
            catch (Exception e) {
                this.logger.error("Error constructing pgtUrl", (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            this.logger.debug("Could not identify service and/or service ticket for service: [{}]", (Object)service);
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST", null);
        }
        try {
            Credential serviceCredential = this.getServiceCredentialsFromRequest(service, request);
            TicketGrantingTicket proxyGrantingTicketId = null;
            if (serviceCredential != null) {
                try {
                    proxyGrantingTicketId = this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, new Credential[]{serviceCredential});
                    this.logger.debug("Generated PGT [{}] off of service ticket [{}] and credential [{}]", new Object[]{proxyGrantingTicketId.getId(), serviceTicketId, serviceCredential});
                }
                catch (AuthenticationException e) {
                    this.logger.info("Failed to authenticate service credential {}", (Object)serviceCredential);
                }
                catch (TicketException e) {
                    this.logger.error("Failed to create proxy granting ticket for {}", (Object)serviceCredential, (Object)e);
                }
                if (proxyGrantingTicketId == null) {
                    return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()});
                }
            }
            Assertion assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, (Service)service);
            ValidationSpecification validationSpecification = this.getCommandClass();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)validationSpecification, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (!validationSpecification.isSatisfiedBy(assertion)) {
                this.logger.debug("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
                return this.generateErrorView("INVALID_TICKET", "INVALID_TICKET", null);
            }
            String proxyIou = null;
            if (serviceCredential != null && this.proxyHandler.canHandle(serviceCredential) && StringUtils.isEmpty((Object)(proxyIou = this.proxyHandler.handle(serviceCredential, proxyGrantingTicketId)))) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()});
            }
            this.onSuccessfulValidation(serviceTicketId, assertion);
            this.logger.debug("Successfully validated service ticket {} for service [{}]", (Object)serviceTicketId, (Object)service.getId());
            return this.generateSuccessView(assertion, proxyIou, service, proxyGrantingTicketId);
        }
        catch (TicketValidationException e) {
            String code = e.getCode();
            return this.generateErrorView(code, code, new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()});
        }
        catch (TicketException te) {
            return this.generateErrorView(te.getCode(), te.getCode(), new Object[]{serviceTicketId});
        }
        catch (UnauthorizedProxyingException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), new Object[]{service.getId()});
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), null);
        }
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        String convertedDescription = this.getMessageSourceAccessor().getMessage(description, args, description);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)convertedDescription);
        return modelAndView;
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou, WebApplicationService service, TicketGrantingTicket proxyGrantingTicket) {
        Map<String, ?> augmentedModelObjects;
        ModelAndView success = new ModelAndView(this.successView);
        success.addObject("assertion", (Object)assertion);
        success.addObject("service", (Object)service);
        success.addObject("pgtIou", (Object)proxyIou);
        if (proxyGrantingTicket != null) {
            success.addObject("proxyGrantingTicket", (Object)proxyGrantingTicket.getId());
        }
        if ((augmentedModelObjects = this.augmentSuccessViewModelObjects(assertion)) != null) {
            success.addAllObjects(augmentedModelObjects);
        }
        return success;
    }

    protected Map<String, ?> augmentSuccessViewModelObjects(Assertion assertion) {
        return Collections.emptyMap();
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public final void setValidationSpecificationClass(Class<?> validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public final void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public final void setSuccessView(String successView) {
        this.successView = successView;
    }

    public final void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public final void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }
}

