/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.ant.deploy;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jasig.portal.tools.deployer.DeployerConfig;
import org.jasig.portal.tools.deployer.tomcat.TomcatDeployerConfig;
import org.jasig.portal.tools.deployer.tomcat.TomcatEarDeployer;

public class TomcatEarDeployerTask
extends Task {
    public static final String DEFAULT_WEBAPPS_DIR = "webapps";
    public static final String DEFAULT_JAR_DIR = "shared/lib";
    private String webAppsDir;
    private String jarDir;
    private File catalinaBase;
    private File ear;
    private boolean extractWars = false;
    private boolean removeExistingDirectories = false;

    public String getWebAppsDir() {
        return this.webAppsDir;
    }

    public void setWebAppsDir(String webAppsDir) {
        this.webAppsDir = webAppsDir;
    }

    public String getJarDir() {
        return this.jarDir;
    }

    public void setJarDir(String jarDir) {
        this.jarDir = jarDir;
    }

    public File getCatalinaBase() {
        return this.catalinaBase;
    }

    public void setCatalinaBase(File catalinaShared) {
        this.catalinaBase = catalinaShared;
    }

    public File getEar() {
        return this.ear;
    }

    public void setEar(File ear) {
        this.ear = ear;
    }

    public boolean isExtractWars() {
        return this.extractWars;
    }

    public void setExtractWars(boolean extractWars) {
        this.extractWars = extractWars;
    }

    public boolean isRemoveExistingDirectories() {
        return this.removeExistingDirectories;
    }

    public void setRemoveExistingDirectories(boolean removeExistingDirectories) {
        this.removeExistingDirectories = removeExistingDirectories;
    }

    public void execute() throws BuildException {
        this.validateArgs();
        TomcatDeployerConfig config = new TomcatDeployerConfig();
        File catalinaBase = this.getCatalinaBase();
        File fullJarDir = this.jarDir != null ? new File(this.jarDir) : new File(catalinaBase, DEFAULT_JAR_DIR);
        config.setJarDir(fullJarDir);
        File fullWebAppsDir = this.webAppsDir != null ? new File(this.webAppsDir) : new File(catalinaBase, DEFAULT_WEBAPPS_DIR);
        config.setWebAppsDir(fullWebAppsDir);
        config.setEarLocation(this.getEar());
        config.setExtractWars(this.isExtractWars());
        config.setRemoveExistingDirectories(this.isRemoveExistingDirectories());
        TomcatEarDeployer deployer = new TomcatEarDeployer();
        try {
            deployer.deployEar((DeployerConfig)config);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void validateArgs() throws BuildException {
        if (this.ear == null) {
            throw new BuildException("ear is a required property");
        }
        if (!this.ear.exists()) {
            throw new BuildException("ear '" + this.ear.getAbsolutePath() + "' does not exist");
        }
        if (this.catalinaBase == null) {
            throw new BuildException("catalinaBase is a required property");
        }
    }
}

