/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javassist.CtClass;
import org.javalite.instrumentation.InstrumentationModelFinder;
import org.javalite.instrumentation.ModelInstrumentation;

public class Instrumentation {
    private String outputDirectory;

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void instrument() {
        if (this.outputDirectory == null) {
            throw new RuntimeException("Property 'outputDirectory' must be provided");
        }
        try {
            System.out.println("**************************** START INSTRUMENTATION ****************************");
            System.out.println("Directory: " + this.outputDirectory);
            InstrumentationModelFinder mf = new InstrumentationModelFinder();
            File target = new File(this.outputDirectory);
            mf.processDirectoryPath(target);
            ModelInstrumentation mi = new ModelInstrumentation();
            for (CtClass clazz : mf.getModels()) {
                mi.instrument(clazz);
            }
            Instrumentation.generateModelsFile(mf.getModels(), target);
            System.out.println("**************************** END INSTRUMENTATION ****************************");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateModelsFile(List<CtClass> models, File target) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String modelsFileName = target.getAbsolutePath() + System.getProperty("file.separator") + "activejdbc_models.properties";
        FileOutputStream fout = new FileOutputStream(modelsFileName);
        for (CtClass model : models) {
            fout.write((model.getName() + ":" + Instrumentation.getDatabaseName(model) + "\n").getBytes());
        }
        fout.close();
    }

    static String getDatabaseName(CtClass model) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] annotations;
        for (Object annotation : annotations = model.getAnnotations()) {
            Class<?> dbNameClass = Class.forName("org.javalite.activejdbc.annotations.DbName");
            if (!dbNameClass.isAssignableFrom(annotation.getClass())) continue;
            Method valueMethod = annotation.getClass().getMethod("value", new Class[0]);
            return valueMethod.invoke(annotation, new Object[0]).toString();
        }
        return "default";
    }
}

