/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.managed_5_1;

import java.io.File;
import java.util.HashMap;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.deployment.Validate;

public class JBossASConfiguration
implements ContainerConfiguration {
    private String bindAddress = "localhost";
    private int httpPort = 8080;
    private int rmiPort = 1099;
    private String profileName = "default";
    private String partition = null;
    private String portBindingSet = null;
    private boolean useRmiPortForAliveCheck = false;
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String javaVmArguments = "-Xmx512m -XX:MaxPermSize=128m";
    private int startupTimeoutInSeconds = 120;
    private int shutdownTimeoutInSeconds = 45;

    public JBossASConfiguration() {
        if (this.javaHome == null || this.javaHome.isEmpty()) {
            this.javaHome = System.getProperty("java.home");
        }
    }

    public void validate() throws ConfigurationException {
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)"Either JBOSS_HOME environment variable or jbossHome property in Arquillian configuration must be set and point to a valid directory");
        Validate.configurationDirectoryExists((String)this.javaHome, (String)"Either JAVA_HOME environment variable or javaHome property in Arquillian configuration must be set and point to a valid directory");
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getPortBindingSet() {
        return this.portBindingSet;
    }

    public void setPortBindingSet(String portBindingSet) {
        this.portBindingSet = portBindingSet;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public void setUseRmiPortForAliveCheck(boolean checkAliveUsingRmiPort) {
        this.useRmiPortForAliveCheck = checkAliveUsingRmiPort;
    }

    public boolean isUseRmiPortForAliveCheck() {
        return this.useRmiPortForAliveCheck;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getJbossHome() {
        if (this.jbossHome != null) {
            return new File(this.jbossHome).getAbsolutePath();
        }
        return this.jbossHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getShutdownTimeoutInSeconds() {
        return this.shutdownTimeoutInSeconds;
    }

    public void setShutdownTimeoutInSeconds(int shutdownTimeoutInSeconds) {
        this.shutdownTimeoutInSeconds = shutdownTimeoutInSeconds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum JBossBindingSet {
        PORTS_01("ports-01", 100),
        PORTS_02("ports-02", 200),
        PORTS_03("ports-03", 300);

        private final String name;
        private final int rmiPort;
        private final int httpPort;
        private static final HashMap<String, JBossBindingSet> bindings;

        static JBossBindingSet getBindingSet(String name) {
            return bindings.get(name);
        }

        private JBossBindingSet(String name, int offSet) {
            this.name = name;
            this.rmiPort = 1099 + offSet;
            this.httpPort = 8080 + offSet;
        }

        int getRmiPort() {
            return this.rmiPort;
        }

        int getHttpPort() {
            return this.httpPort;
        }

        static {
            bindings = new HashMap();
            for (JBossBindingSet binding : JBossBindingSet.values()) {
                bindings.put(binding.name, binding);
            }
        }
    }
}

