/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location.decider;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.graphene.location.LocationEnricher;
import org.jboss.arquillian.graphene.location.exception.LocationException;
import org.jboss.arquillian.graphene.spi.location.LocationDecider;
import org.jboss.arquillian.graphene.spi.location.Scheme;

public class ResourceLocationDecider
implements LocationDecider {
    private static final Scheme scheme = new Scheme.RESOURCE();

    public Scheme canDecide() {
        return scheme;
    }

    public String decide(String location) {
        URL url;
        Validate.notNull((Object)location, (String)"Location to decide can not be a null object.");
        if (!location.startsWith(scheme.toString())) {
            location = scheme.toString() + location;
        }
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new LocationException(String.format("Unable to convert '%s' to URI", location), ex.getCause());
        }
        String resourceName = uri.getSchemeSpecificPart();
        if (resourceName.startsWith("//")) {
            resourceName = resourceName.substring(2);
        }
        if ((url = LocationEnricher.class.getClassLoader().getResource(resourceName)) == null) {
            throw new IllegalArgumentException(String.format("Resource '%s' specified by %s was not found", resourceName, location));
        }
        return url.toExternalForm();
    }
}

